/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.internal;

public class CharacterSet {
    private int minChar;
    private int maxChar;
    boolean[] table;

    public CharacterSet(String chars) {
        int c;
        if (chars.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.minChar = Integer.MAX_VALUE;
        this.maxChar = Integer.MIN_VALUE;
        int i = 0;
        while (i < chars.length()) {
            c = chars.charAt(i);
            if (c != 45 || i <= 0 || i >= chars.length() - 1) {
                this.minChar = Math.min(this.minChar, c);
                this.maxChar = Math.max(this.maxChar, c);
            }
            ++i;
        }
        this.table = new boolean[this.maxChar - this.minChar + 1];
        i = 0;
        while (i < chars.length()) {
            c = chars.charAt(i);
            if (i < chars.length() - 2 && chars.charAt(i + 1) == '-') {
                int c2 = chars.charAt(i + 2);
                if (c > c2) {
                    int temp = c;
                    c = c2;
                    c2 = temp;
                }
                int j = c;
                while (j <= c2) {
                    this.table[j - this.minChar] = true;
                    ++j;
                }
                i += 2;
            } else {
                this.table[c - this.minChar] = true;
            }
            ++i;
        }
    }

    public boolean contains(char c_) {
        char c = c_;
        return c >= this.minChar && c <= this.maxChar && this.table[c - this.minChar];
    }
}

