/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;

public class TForAllAst
extends TypeAst {
    public final String[] vars;
    public final TypeAst type;

    public TForAllAst(String[] vars, TypeAst type) {
        this.vars = vars;
        this.type = type;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("forall");
        String[] stringArray = this.vars;
        int n = this.vars.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            b.append(' ');
            b.append(var);
            ++n2;
        }
        b.append(". ");
        this.type.toString(b);
    }

    @Override
    public Type toType(TypeElaborationContext context) throws SCLTypeParseException {
        TVar[] oldVars = new TVar[this.vars.length];
        int i = 0;
        while (i < this.vars.length) {
            oldVars[i] = context.push(this.vars[i]);
            ++i;
        }
        Type result = this.type.toType(context);
        int i2 = this.vars.length - 1;
        while (i2 >= 0) {
            result = Types.forAll(context.pop(this.vars[i2], oldVars[i2]), result);
            --i2;
        }
        return result;
    }

    @Override
    public int getPrecedence() {
        return 2;
    }
}

