/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.deriving;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.ByteConstant;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.deriving.DerivingUtils;
import org.simantics.scl.compiler.internal.deriving.InstanceDeriver;
import org.simantics.scl.compiler.internal.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.internal.parsing.expressions.Expressions;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.internal.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.internal.parsing.types.TVarAst;
import org.simantics.scl.compiler.types.TCon;

class IODeriver
implements InstanceDeriver {
    IODeriver() {
    }

    @Override
    public void derive(ErrorLog errorLog, Environment environment, ArrayList<ProcessedDInstanceAst> instancesAst, DDerivingInstanceAst der) {
        String[] par;
        Constructor constructor;
        TCon con;
        if (der.types.length != 1) {
            errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = DerivingUtils.getHeadType(der.types[0]);
        if (headType == null) {
            errorLog.log(der.types[0].location, "Cannot derive IO instance for the type " + headType + ".");
            return;
        }
        try {
            con = Environments.getTypeDescriptorName(environment, headType.name);
        }
        catch (AmbiguousNameException e1) {
            errorLog.log(headType.location, e1.getMessage());
            return;
        }
        if (con == null) {
            errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeDescriptor tdesc = environment.getTypeDescriptor(con);
        if (tdesc == null) {
            errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tdesc instanceof TypeAlias) {
            errorLog.log(headType.location, "Cannot derive instance for a type alias.");
            return;
        }
        TypeConstructor tcon = (TypeConstructor)tdesc;
        if (tcon.isOpen) {
            errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        SCLValue write = environment.getValue(Names.Serialization_write);
        SCLValue read = environment.getValue(Names.Serialization_read);
        SCLValue ioSize = environment.getValue(Names.Serialization_ioSize);
        int id = 0;
        while (id < tcon.constructors.length) {
            constructor = tcon.constructors[id];
            int l = constructor.parameterTypes.length;
            par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            EApply lhs = new EApply((Expression)new EVar("write"), new EVar("s"), new EApply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            ArrayList<Expression> statements = new ArrayList<Expression>();
            statements.add(new EApply((Expression)new EConstant(write), new EVar("s"), new ELiteral(new ByteConstant((byte)id))));
            int i2 = 0;
            while (i2 < l) {
                statements.add(new EApply((Expression)new EConstant(write), new EVar("s"), new EVar(par[i2])));
                ++i2;
            }
            Expression rhs = EBlock.create(statements);
            try {
                DValueAst valueAst = new DValueAst(lhs, rhs);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++id;
        }
        EApply lhs = new EApply((Expression)new EVar("read"), (Expression)new EVar("s"));
        Case[] cases = new Case[tcon.constructors.length];
        int id2 = 0;
        while (id2 < tcon.constructors.length) {
            Constructor constructor2 = tcon.constructors[id2];
            int l = constructor2.parameterTypes.length;
            String[] par2 = new String[l];
            int i = 0;
            while (i < l) {
                par2[i] = "v" + i;
                ++i;
            }
            ArrayList<LetStatement> assignments = new ArrayList<LetStatement>(l);
            int i3 = 0;
            while (i3 < l) {
                assignments.add(new LetStatement(new EVar(par2[i3]), new EApply((Expression)new EConstant(read), (Expression)new EVar("s"))));
                ++i3;
            }
            EApply in = new EApply((Expression)new EVar(constructor2.name.name), Expressions.vars(par2));
            cases[id2] = new Case(new ELiteral(new ByteConstant((byte)id2)), (Expression)new EPreLet(assignments, in));
            ++id2;
        }
        EMatch rhs = new EMatch(new EApply((Expression)new EConstant(read), (Expression)new EVar("s")), cases);
        try {
            DValueAst valueAst = new DValueAst(lhs, rhs);
            valueAst.setLocationDeep(der.location);
            valueDefs.add(valueAst);
        }
        catch (NotPatternException e) {
            errorLog.log(e.getExpression().location, "Not a pattern.");
        }
        id = 0;
        while (id < tcon.constructors.length) {
            constructor = tcon.constructors[id];
            int l = constructor.parameterTypes.length;
            par = new String[l];
            int i = 0;
            while (i < l) {
                par[i] = "v" + i;
                ++i;
            }
            EApply lhs2 = new EApply((Expression)new EVar("ioSize"), (Expression)new EApply((Expression)new EVar(constructor.name.name), Expressions.vars(par)));
            Expression rhs2 = new ELiteral(new IntegerConstant(1));
            int i4 = 0;
            while (i4 < l) {
                rhs2 = new EApply((Expression)new EVar("+"), rhs2, new EApply((Expression)new EConstant(ioSize), (Expression)new EVar(par[i4])));
                ++i4;
            }
            try {
                DValueAst valueAst = new DValueAst(lhs2, rhs2);
                valueAst.setLocationDeep(der.location);
                valueDefs.add(valueAst);
            }
            catch (NotPatternException e) {
                errorLog.log(e.getExpression().location, "Not a pattern.");
            }
            ++id;
        }
        instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }
}

