/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa.exits;

import java.util.ArrayList;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public class Throw2
extends SSAExit {
    ValRef exception;

    public Throw2(int lineNumber, ValRef exception) {
        super(lineNumber);
        this.exception = exception;
    }

    @Override
    public void toString(PrintingContext context) {
        context.append("throw ");
        context.append(this.exception);
        context.append('\n');
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        mb.lineNumber(this.lineNumber);
        mb.pushBoxed(this.exception.getBinding());
        mb.throwObject();
    }

    @Override
    public void validate(SSAValidationContext context) {
    }

    @Override
    public void destroy() {
        this.exception.remove();
    }

    @Override
    public SSAExit copy(CopyContext context) {
        return new Throw2(this.lineNumber, this.exception.copy());
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
    }

    @Override
    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
    }

    @Override
    public Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy) {
        return proxy;
    }

    @Override
    public SSABlock[] getSuccessors() {
        return SSABlock.EMPTY_ARRAY;
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
    }

    @Override
    public void cleanup() {
    }
}

