/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.Assignment;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELet;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.FunctionDefinitionLhs;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;

public class EPreLet
extends ASTExpression {
    public List<LetStatement> assignments;
    public Expression in;

    public EPreLet(List<LetStatement> assignments, Expression in) {
        this.assignments = assignments;
        this.in = in;
    }

    @Override
    public Expression resolve(final TranslationContext context) {
        context.pushFrame();
        THashMap functionDefinitions = new THashMap();
        ArrayList<LetStatement> otherDefinitions = new ArrayList<LetStatement>();
        final THashMap localVars = new THashMap();
        try {
            for (LetStatement assign : this.assignments) {
                LhsType lhsType = assign.pattern.getLhsType();
                if (!(assign.pattern instanceof EVar) && lhsType instanceof FunctionDefinitionLhs) {
                    String name = ((FunctionDefinitionLhs)lhsType).functionName;
                    ArrayList<LetStatement> group = (ArrayList<LetStatement>)functionDefinitions.get((Object)name);
                    if (group == null) {
                        group = new ArrayList<LetStatement>(2);
                        functionDefinitions.put((Object)name, group);
                    }
                    group.add(assign);
                    localVars.put((Object)name, (Object)context.newVariable(name));
                    continue;
                }
                otherDefinitions.add(assign);
                assign.pattern = assign.pattern.resolveAsPattern(context);
            }
        }
        catch (NotPatternException e) {
            context.getErrorLog().log(e.getExpression().location, "Not a pattern.");
            return new EError();
        }
        final ArrayList<Assignment> as = new ArrayList<Assignment>(functionDefinitions.size() + otherDefinitions.size());
        functionDefinitions.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, ArrayList<LetStatement>>(){

            public boolean execute(String name, ArrayList<LetStatement> cases) {
                as.add(new Assignment(new EVariable(cases.size() == 1 ? cases.get((int)0).pattern.location : EPreLet.this.location, (Variable)localVars.get((Object)name)), context.translateCases(cases)));
                return true;
            }
        });
        for (LetStatement stat : otherDefinitions) {
            as.add(new Assignment(stat.pattern, stat.value.resolve(context)));
        }
        Expression inExpr = this.in.resolve(context);
        context.popFrame();
        ELet result = new ELet(this.location, as.toArray(new Assignment[as.size()]), inExpr);
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            for (LetStatement assignment : this.assignments) {
                assignment.setLocationDeep(loc);
            }
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return this.in.getSyntacticFunctionArity();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

