/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class ClaimOp
extends PlanOp {
    CHRConstraint constraint;
    Expression[] parameters;

    public ClaimOp(long location, CHRConstraint constraint, Expression[] parameters) {
        super(location);
        this.constraint = constraint;
        this.parameters = parameters;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("CLAIM   ").append(this.constraint);
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Expression parameter = expressionArray[n2];
            b.append(" (").append(parameter).append(')');
            ++n2;
        }
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        IVal[] parameterVars = new IVal[this.parameters.length + 1];
        parameterVars[0] = planContext.generateNewId(this.location, w);
        int i = 0;
        while (i < this.parameters.length) {
            parameterVars[i + 1] = this.parameters[i].toVal(context, w);
            ++i;
        }
        IVal newFact = w.apply(this.location, this.constraint.constructor, parameterVars);
        w.apply(this.location, this.constraint.addProcedure, planContext.getStoreVar(this.constraint), planContext.contextVar, newFact);
        planContext.nextOp(w);
    }
}

