/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib.exceptions;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class HDF5LibraryException
extends HDF5Exception {
    public HDF5LibraryException() {
        try {
            H5.H5open();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.detailMessage = this.getMinorError(this.getMinorErrorNumber());
    }

    public HDF5LibraryException(String string) {
        super(string);
        try {
            H5.H5open();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public native long getMajorErrorNumber();

    public native long getMinorErrorNumber();

    public String getMinorError(long l) {
        if (l == 0L) {
            return "special zero no error";
        }
        if (l == HDF5Constants.H5E_UNINITIALIZED) {
            return "information is unitialized";
        }
        if (l == HDF5Constants.H5E_UNSUPPORTED) {
            return "feature is unsupported";
        }
        if (l == HDF5Constants.H5E_BADTYPE) {
            return "incorrect type found";
        }
        if (l == HDF5Constants.H5E_BADRANGE) {
            return "argument out of range";
        }
        if (l == HDF5Constants.H5E_BADVALUE) {
            return "bad value for argument";
        }
        if (l == HDF5Constants.H5E_NOSPACE) {
            return "no space available for allocation";
        }
        if (l == HDF5Constants.H5E_CANTCOPY) {
            return "unable to copy object";
        }
        if (l == HDF5Constants.H5E_CANTFREE) {
            return "unable to free object";
        }
        if (l == HDF5Constants.H5E_ALREADYEXISTS) {
            return "Object already exists";
        }
        if (l == HDF5Constants.H5E_CANTLOCK) {
            return "Unable to lock object";
        }
        if (l == HDF5Constants.H5E_CANTUNLOCK) {
            return "Unable to unlock object";
        }
        if (l == HDF5Constants.H5E_FILEEXISTS) {
            return "file already exists";
        }
        if (l == HDF5Constants.H5E_FILEOPEN) {
            return "file already open";
        }
        if (l == HDF5Constants.H5E_CANTCREATE) {
            return "Can't create file";
        }
        if (l == HDF5Constants.H5E_CANTOPENFILE) {
            return "Can't open file";
        }
        if (l == HDF5Constants.H5E_CANTCLOSEFILE) {
            return "Can't close file";
        }
        if (l == HDF5Constants.H5E_NOTHDF5) {
            return "not an HDF5 format file";
        }
        if (l == HDF5Constants.H5E_BADFILE) {
            return "bad file ID accessed";
        }
        if (l == HDF5Constants.H5E_TRUNCATED) {
            return "file has been truncated";
        }
        if (l == HDF5Constants.H5E_MOUNT) {
            return "file mount error";
        }
        if (l == HDF5Constants.H5E_SEEKERROR) {
            return "seek failed";
        }
        if (l == HDF5Constants.H5E_READERROR) {
            return "read failed";
        }
        if (l == HDF5Constants.H5E_WRITEERROR) {
            return "write failed";
        }
        if (l == HDF5Constants.H5E_CLOSEERROR) {
            return "close failed";
        }
        if (l == HDF5Constants.H5E_OVERFLOW) {
            return "address overflowed";
        }
        if (l == HDF5Constants.H5E_FCNTL) {
            return "file fcntl failed";
        }
        if (l == HDF5Constants.H5E_CANTINIT) {
            return "Can't initialize object";
        }
        if (l == HDF5Constants.H5E_ALREADYINIT) {
            return "object already initialized";
        }
        if (l == HDF5Constants.H5E_CANTRELEASE) {
            return "Can't release object";
        }
        if (l == HDF5Constants.H5E_BADATOM) {
            return "Can't find atom information";
        }
        if (l == HDF5Constants.H5E_BADGROUP) {
            return "Can't find group information";
        }
        if (l == HDF5Constants.H5E_CANTREGISTER) {
            return "Can't register new atom";
        }
        if (l == HDF5Constants.H5E_CANTINC) {
            return "Can't increment reference count";
        }
        if (l == HDF5Constants.H5E_CANTDEC) {
            return "Can't decrement reference count";
        }
        if (l == HDF5Constants.H5E_NOIDS) {
            return "Out of IDs for group";
        }
        if (l == HDF5Constants.H5E_CANTFLUSH) {
            return "Can't flush object from cache";
        }
        if (l == HDF5Constants.H5E_CANTLOAD) {
            return "Can't load object into cache";
        }
        if (l == HDF5Constants.H5E_PROTECT) {
            return "protected object error";
        }
        if (l == HDF5Constants.H5E_NOTCACHED) {
            return "object not currently cached";
        }
        if (l == HDF5Constants.H5E_NOTFOUND) {
            return "object not found";
        }
        if (l == HDF5Constants.H5E_EXISTS) {
            return "object already exists";
        }
        if (l == HDF5Constants.H5E_CANTENCODE) {
            return "Can't encode value";
        }
        if (l == HDF5Constants.H5E_CANTDECODE) {
            return "Can't decode value";
        }
        if (l == HDF5Constants.H5E_CANTSPLIT) {
            return "Can't split node";
        }
        if (l == HDF5Constants.H5E_CANTINSERT) {
            return "Can't insert object";
        }
        if (l == HDF5Constants.H5E_CANTLIST) {
            return "Can't list node";
        }
        if (l == HDF5Constants.H5E_LINKCOUNT) {
            return "bad object header link count";
        }
        if (l == HDF5Constants.H5E_VERSION) {
            return "wrong version number";
        }
        if (l == HDF5Constants.H5E_ALIGNMENT) {
            return "alignment error";
        }
        if (l == HDF5Constants.H5E_BADMESG) {
            return "unrecognized message";
        }
        if (l == HDF5Constants.H5E_CANTDELETE) {
            return " Can't delete message";
        }
        if (l == HDF5Constants.H5E_CANTOPENOBJ) {
            return "Can't open object";
        }
        if (l == HDF5Constants.H5E_COMPLEN) {
            return "name component is too long";
        }
        if (l == HDF5Constants.H5E_LINK) {
            return "link count failure";
        }
        if (l == HDF5Constants.H5E_CANTCONVERT) {
            return "Can't convert datatypes";
        }
        if (l == HDF5Constants.H5E_BADSIZE) {
            return "Bad size for object";
        }
        if (l == HDF5Constants.H5E_CANTCLIP) {
            return "Can't clip hyperslab region";
        }
        if (l == HDF5Constants.H5E_CANTCOUNT) {
            return "Can't count elements";
        }
        if (l == HDF5Constants.H5E_CANTSELECT) {
            return "Can't select hyperslab";
        }
        if (l == HDF5Constants.H5E_CANTNEXT) {
            return "Can't move to next iterator location";
        }
        if (l == HDF5Constants.H5E_BADSELECT) {
            return "Invalid selection";
        }
        if (l == HDF5Constants.H5E_CANTGET) {
            return "Can't get value";
        }
        if (l == HDF5Constants.H5E_CANTSET) {
            return "Can't set value";
        }
        if (l == HDF5Constants.H5E_DUPCLASS) {
            return "Duplicate class name in parent class";
        }
        if (l == HDF5Constants.H5E_MPI) {
            return "some MPI function failed";
        }
        if (l == HDF5Constants.H5E_MPIERRSTR) {
            return "MPI Error String";
        }
        if (l == HDF5Constants.H5E_NOFILTER) {
            return "requested filter is not available";
        }
        if (l == HDF5Constants.H5E_CALLBACK) {
            return "callback failed";
        }
        if (l == HDF5Constants.H5E_CANAPPLY) {
            return "error from filter \"can apply\" callback";
        }
        if (l == HDF5Constants.H5E_SETLOCAL) {
            return "error from filter \"set local\" callback";
        }
        return "undefined error(" + l + ")";
    }

    @Override
    public void printStackTrace() {
        System.err.println(this);
        this.printStackTrace0(null);
        super.printStackTrace();
    }

    public void printStackTrace(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canWrite()) {
            this.printStackTrace();
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(this);
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println(this);
            }
            this.printStackTrace0(file.getPath());
            super.printStackTrace();
        }
    }

    private native void printStackTrace0(String var1);
}

