/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDocumentationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleDocumentationSource.class);
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public final String documentationName;
    public final Bundle bundle;
    public final URL url;

    public BundleDocumentationSource(String documentationName, Bundle bundle, URL url) {
        this.documentationName = documentationName;
        this.bundle = bundle;
        this.url = url;
    }

    public String getText() {
        String string;
        InputStream stream = this.url.openStream();
        try {
            int count;
            byte[] buffer = new byte[1024];
            int pos = 0;
            while ((count = stream.read(buffer, pos, buffer.length - pos)) > 0) {
                if ((pos += count) != buffer.length) continue;
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            string = new String(buffer, 0, pos, UTF8);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                LOGGER.error("Could not get text for {} at {}", (Object)this.documentationName, (Object)this.url);
                return null;
            }
        }
        stream.close();
        return string;
    }
}

