/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.util.Collection;

public class GroupException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Throwable[] errors;

    private GroupException(Throwable[] errors) {
        super(GroupException.getAsText(errors));
        this.errors = errors;
    }

    public static Exception group(Exception ... errors) {
        if (errors.length == 0) {
            throw new IllegalArgumentException("zero exceptions for GroupException");
        }
        if (errors.length == 1) {
            return errors[0];
        }
        return new GroupException(errors);
    }

    public static Throwable group(Collection<? extends Throwable> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("zero exceptions for GroupException");
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return new GroupException(collection.toArray(new Exception[collection.size()]));
    }

    private static String getAsText(Throwable[] errors) {
        String result = "";
        Throwable[] throwableArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable error = throwableArray[n2];
            result = String.valueOf(result) + error.getClass().getName() + ": " + error.getMessage() + "\n";
            ++n2;
        }
        return result;
    }

    public Throwable[] getErrors() {
        return this.errors;
    }
}

