/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.tests;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.simantics.scl.runtime.chr.CHRHashIndex;

public class TestCHRHashIndex {
    Random random;
    Store store;
    Store2 store2;
    THashSet<Fact> aliveFacts = new THashSet();

    @Before
    public void init() {
        this.random = new Random(123L);
        this.store = new Store();
        this.store2 = new Store2();
    }

    public Fact createFact(int maxA, int maxB) {
        return new Fact(this.random.nextInt(maxA), this.random.nextInt(maxB));
    }

    public void add(Fact fact) {
        fact.add(this.store);
        fact.add(this.store2);
        this.aliveFacts.add((Object)fact);
    }

    public void remove(Fact fact) {
        fact.remove(this.store);
        fact.remove(this.store2);
        this.aliveFacts.remove((Object)fact);
    }

    public void checkConsistency() {
        TIntHashSet keys = new TIntHashSet();
        for (Fact fact : this.aliveFacts) {
            keys.add(fact.a);
        }
        Fact temp = new Fact(0, 0);
        int[] nArray = keys.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int a;
            temp.a = a = nArray[n2];
            Assert.assertEquals(temp.get(this.store2), temp.get(this.store));
            ++n2;
        }
        TIntHashSet keys2 = new TIntHashSet();
        Fact[] factArray = this.store.bfIndex.toArray(new Fact[keys.size()]);
        int n3 = factArray.length;
        n = 0;
        while (n < n3) {
            Fact fact = factArray[n];
            keys2.add(fact.a);
            ++n;
        }
        Assert.assertEquals((Object)keys, (Object)keys2);
    }

    @Test
    public void testStore() {
        int i = 0;
        while (true) {
            System.out.println("Run " + i);
            int j = 0;
            while (j < 1000000) {
                this.add(this.createFact(10000, 1000000));
                ++j;
            }
            this.checkConsistency();
            ArrayList<Fact> factArray = new ArrayList<Fact>((Collection<Fact>)this.aliveFacts);
            Collections.shuffle(factArray, this.random);
            for (Fact fact : factArray.subList(100000, factArray.size())) {
                this.remove(fact);
            }
            this.checkConsistency();
            ++i;
        }
    }

    public static class Fact {
        public int a;
        public int b;
        public Fact bfPrev;
        public Fact bfNext;

        public Fact(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public void add(Store store) {
            this.bfNext = (Fact)store.bfIndex.addFreshAndReturnOld(this);
            if (this.bfNext != null) {
                this.bfNext.bfPrev = this;
            }
        }

        public void remove(Store store) {
            if (this.bfPrev == null) {
                if (this.bfNext == null) {
                    store.bfIndex.removeKnownToExistKey(this);
                } else {
                    this.bfNext.bfPrev = null;
                    store.bfIndex.replaceKnownToExistKey(this, this.bfNext);
                }
            } else {
                this.bfPrev.bfNext = this.bfNext;
                if (this.bfNext != null) {
                    this.bfNext.bfPrev = this.bfPrev;
                }
            }
        }

        public List<Fact> get(Store store) {
            Object r = store.bfIndex.getEqual(this);
            if (r == null) {
                return Collections.emptyList();
            }
            ArrayList<Fact> result = new ArrayList<Fact>();
            Fact cur = (Fact)r;
            while (cur != null) {
                result.add(cur);
                cur = cur.bfNext;
            }
            Collections.reverse(result);
            return result;
        }

        public void add(Store2 store) {
            LinkedHashSet<Fact> set = (LinkedHashSet<Fact>)store.bfIndex.get(this.a);
            if (set == null) {
                set = new LinkedHashSet<Fact>();
                store.bfIndex.put(this.a, set);
            }
            set.add(this);
        }

        public void remove(Store2 store) {
            ((LinkedHashSet)store.bfIndex.get(this.a)).remove(this);
        }

        public List<Fact> get(Store2 store) {
            LinkedHashSet set = (LinkedHashSet)store.bfIndex.get(this.a);
            if (set == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Fact>(set);
        }
    }

    public static class Store {
        CHRHashIndex bfIndex = new CHRHashIndex(){

            @Override
            protected boolean keyEquals(Object a, Object b) {
                return ((Fact)a).a == ((Fact)b).a;
            }

            @Override
            protected int keyHashCode(Object key) {
                return ((Fact)key).a;
            }
        };
    }

    public static class Store2 {
        TIntObjectHashMap<LinkedHashSet<Fact>> bfIndex = new TIntObjectHashMap();
    }
}

