/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.profiling;

public class BranchPoint {
    public static final BranchPoint[] EMPTY_ARRAY = new BranchPoint[0];
    private final long location;
    private final int codeSize;
    private final BranchPoint[] children;
    public int visitCounter;

    public BranchPoint(long location, int codeSize, BranchPoint[] children) {
        this.location = location;
        this.codeSize = codeSize;
        this.children = children;
    }

    public void resetVisitCountersRecursively() {
        this.visitCounter = 0;
        BranchPoint[] branchPointArray = this.getChildren();
        int n = branchPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            BranchPoint branchPoint = branchPointArray[n2];
            branchPoint.resetVisitCountersRecursively();
            ++n2;
        }
    }

    public long getLocation() {
        return this.location;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public int getVisitCounter() {
        return this.visitCounter;
    }

    public void incrementVisitCounter(int amount) {
        this.visitCounter += amount;
    }

    public BranchPoint[] getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BP[visitCounter=").append(this.visitCounter).append(", codeSize=").append(this.codeSize).append(", location=").append(this.location);
        if (this.children.length > 0) {
            sb.append(", children=").append(this.children.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

