/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmil.core;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.fmil.core.ExecEnvironment;
import org.simantics.fmil.core.FMILException;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIL {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIL.class);
    private static final boolean DEBUG = false;
    private static int OK = 0;
    private static int ERROR = 1;
    private static int PENDING = 2;
    private static String UNSATISFIED_LINK = "Method not found. DLL might not be loaded properly.";
    public static final String TEMP_FMU_DIRECTORY_NAME = "fmil";
    public static String TEMP_FMU_COMMON_DIRECTORY;
    public static String LOCK_FILE_NAME;
    public static Object syncObject;
    private String fmuDir;
    private int id;
    public String TEMP_FOLDER_1;
    public String TEMP_FOLDER_2;
    public String TEMP_FMU_DIRECTORY;
    private String dirName;
    private String[] variableNames;
    private String[] variableDescriptions;
    private String[] variableDeclaredTypes;
    private int[] variableReferences;
    private int[] variableTypes;
    private int[] variableCausalities;
    private int[] variableVariabilities;
    private String[] declaredTypes;
    private String[] declaredTypeDescriptions;
    private String[] declaredTypeQuantities;
    private String[] declaredTypeUnits;
    private static int NO_VARIABLE_KEY;
    private TObjectIntHashMap<String> variableMap = new TObjectIntHashMap(10, 0.5f, NO_VARIABLE_KEY);
    private Set<String> subscriptionSet = new HashSet<String>();
    private TIntArrayList subscription = new TIntArrayList();
    private ArrayList<String> subscribedNames = new ArrayList();
    private int fmuN = 0;
    private boolean instantiated = false;
    private FileChannel channel;
    private FileLock lock;

    static {
        LOCK_FILE_NAME = "fmil.lock";
        syncObject = new Object();
        File[] libraries = new File[2];
        ExecEnvironment env = ExecEnvironment.calculate();
        try {
            URL sharedFMILIBUrl = null;
            URL simulatorFMIUrl = null;
            Bundle b = Platform.getBundle((String)"org.simantics.fmil.core");
            if (env.os == ExecEnvironment.OSType.WINDOWS) {
                sharedFMILIBUrl = FileLocator.find((Bundle)b, (IPath)new Path("libraries/fmilib_shared.dll"), null);
                simulatorFMIUrl = FileLocator.find((Bundle)b, (IPath)new Path("libraries/FMUSimulator.dll"), null);
            } else if (env.os == ExecEnvironment.OSType.LINUX) {
                sharedFMILIBUrl = FileLocator.find((Bundle)b, (IPath)new Path("libraries/libfmilib_shared.so"), null);
                simulatorFMIUrl = FileLocator.find((Bundle)b, (IPath)new Path("libraries/libFMUSimulator.so"), null);
            }
            libraries[0] = new File(FileLocator.toFileURL((URL)sharedFMILIBUrl).getPath());
            libraries[1] = new File(FileLocator.toFileURL((URL)simulatorFMIUrl).getPath());
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve native FMU simulation library for execution environment {}.{}", new Object[]{env.os, env.arch, e});
        }
        File[] fileArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            File library = fileArray[n2];
            if (library == null) {
                System.err.println("FMU library not loaded. FMU simulation not working.");
            } else if (!library.isFile()) {
                System.err.println(String.valueOf(library.getAbsolutePath()) + " not found");
            } else {
                try {
                    System.load(library.getAbsolutePath());
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                }
            }
            ++n2;
        }
        TEMP_FMU_COMMON_DIRECTORY = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        NO_VARIABLE_KEY = -1;
    }

    public static void setTempFMUCommonDir(File dir) {
        TEMP_FMU_COMMON_DIRECTORY = dir.getAbsolutePath();
    }

    public List<String> getSubscribedNames() {
        return this.subscribedNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscribe(String name) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            int vr;
            block6: {
                block5: {
                    vr = this.variableMap.get((Object)name);
                    if (vr != NO_VARIABLE_KEY) break block5;
                    return false;
                }
                if (this.subscriptionSet.add(name)) break block6;
                return false;
            }
            this.subscribedNames.add(name);
            this.subscription.add(vr);
            this.subscribe(new int[]{vr});
            return true;
        }
    }

    public FMIL() {
        File tempDir = new File(TEMP_FMU_COMMON_DIRECTORY, UUID.randomUUID().toString());
        tempDir.mkdir();
        this.TEMP_FMU_DIRECTORY = tempDir.getAbsolutePath();
        this.dirName = UUID.randomUUID().toString();
        File fmuDir = new File(this.TEMP_FMU_DIRECTORY, this.dirName);
        fmuDir.mkdir();
        this.TEMP_FOLDER_1 = fmuDir.toString();
        this.TEMP_FOLDER_2 = String.valueOf(fmuDir.toString()) + "_2";
        this.lockFMUDirectory();
    }

    public int getModelIDNew() {
        return this.id;
    }

    public String getModelID() {
        return this.dirName;
    }

    public String getFmuDir() {
        return this.fmuDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFMUFile(String path) throws FMILException {
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new FMILException("File " + path + " does not exist");
        }
        if (!Files.isRegularFile(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new FMILException("Path " + path + " is not a file");
        }
        Object object = syncObject;
        synchronized (object) {
            if (this.fmuN % 2 == 0) {
                this.fmuDir = this.TEMP_FOLDER_1;
                ++this.fmuN;
            } else {
                this.fmuDir = this.TEMP_FOLDER_2;
                this.fmuN = 0;
            }
            java.nio.file.Path tempDir = Paths.get(this.fmuDir, new String[0]);
            if (Files.exists(tempDir, new LinkOption[0]) && Files.isDirectory(tempDir, new LinkOption[0])) {
                try {
                    FileUtils.emptyDirectory((java.nio.file.Path)tempDir);
                }
                catch (IOException e) {
                    throw new FMILException("Could not delete existing files from temp folder for fmu " + path, e);
                }
            }
            try {
                Files.createDirectory(tempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new FMILException("Could not create temp folder for fmu " + path, e);
            }
            try {
                String tmpPath = tempDir.toString();
                if (!tmpPath.endsWith("\\") && !tmpPath.endsWith("/")) {
                    tmpPath = String.valueOf(tmpPath) + "/";
                }
                this.id = this.loadFMUFile_(path, tmpPath);
                this.getAllVariables();
                this.getAllVariableReferences();
                int i = 0;
                while (i < this.variableNames.length) {
                    this.variableMap.put((Object)this.variableNames[i], this.variableReferences[i]);
                    ++i;
                }
                this.instantiated = false;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK, err);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int loadFMUFile_(String var1, String var2) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStepLength(double step) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setStepLength_(this.getModelIDNew(), step);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setStepLength_(int var1, double var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateSimulation() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.instantiateSimulation_(this.getModelIDNew());
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                } else {
                    this.instantiated = true;
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int instantiateSimulation_(int var1) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSimulation() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.initializeSimulation_(this.getModelIDNew());
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int initializeSimulation_(int var1) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(int[] variables) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.subscribe_(this.getModelIDNew(), variables);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int subscribe_(int var1, int[] var2);

    public void setRealValue(String name, double value) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        this.setRealValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRealValue(int variableReference, double value) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setRealValue_(this.getModelIDNew(), variableReference, value);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setRealValue_(int var1, int var2, double var3) throws FMILException;

    public void setIntegerValue(String name, int value) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        this.setIntegerValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegerValue(int variableReference, int value) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setIntegerValue_(this.getModelIDNew(), variableReference, value);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setIntegerValue_(int var1, int var2, int var3) throws FMILException;

    public void setBooleanValue(String name, boolean value) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        this.setBooleanValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanValue(int variableReference, boolean value) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setBooleanValue_(this.getModelIDNew(), variableReference, value);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setBooleanValue_(int var1, int var2, boolean var3) throws FMILException;

    public void setStringValue(String name, String value) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        this.setStringValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringValue(int variableReference, String value) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.setStringValue_(this.getModelIDNew(), variableReference, value);
                if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int setStringValue_(int var1, int var2, String var3) throws FMILException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateStep() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                int ret = this.simulateStep_(this.getModelIDNew());
                if (ret == PENDING) {
                    LOGGER.warn("Pending status return from FMU. This is not implemented in our Simulator yet!");
                } else if (ret != OK) {
                    LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                }
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int simulateStep_(int var1) throws FMILException;

    public double[] getSubscribedResults() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                double[] results = new double[this.subscription.size()];
                Arrays.fill(results, Double.NaN);
                return this.getSubscribedResults_(this.getModelIDNew(), results);
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native double[] getSubscribedResults_(int var1, double[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadFMU() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                this.unlockFMUDirectory();
                if (this.instantiated) {
                    int ret = this.unloadFMU_(this.getModelIDNew());
                    if (ret != OK) {
                        LOGGER.warn("Function return value != OK, an exception should have been thrown from native code!");
                    }
                    this.instantiated = false;
                }
                this.removeFMUDirectoryContents();
            }
            catch (FMILException e) {
                throw e;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int unloadFMU_(int var1) throws FMILException;

    public double getTime() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getTime_(this.getModelIDNew());
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native double getTime_(int var1);

    public String[] getAllVariables() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableNames == null) {
                    this.variableNames = this.getAllVariables_(this.getModelIDNew());
                }
                return this.variableNames;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariables_(int var1);

    public String[] getAllVariableDescriptions() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableDescriptions == null) {
                    this.variableDescriptions = this.getAllVariableDescriptions_(this.getModelIDNew());
                }
                return this.variableDescriptions;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariableDescriptions_(int var1);

    public String[] getAllVariableDeclaredTypes() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableDeclaredTypes == null) {
                    this.variableDeclaredTypes = this.getAllVariableDeclaredTypes_(this.getModelIDNew());
                }
                return this.variableDeclaredTypes;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllVariableDeclaredTypes_(int var1);

    public int[] getAllVariableReferences() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableReferences == null) {
                    this.variableReferences = this.getAllVariableReferences_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableReferences;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableReferences_(int var1, int[] var2);

    public int[] getAllVariableTypes() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableTypes == null) {
                    this.variableTypes = this.getAllVariableTypes_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableTypes;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableTypes_(int var1, int[] var2);

    public int[] getAllVariableCausalities() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableCausalities == null) {
                    this.variableCausalities = this.getAllVariableCausalities_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableCausalities;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableCausalities_(int var1, int[] var2);

    public int[] getAllVariableVariabilities() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.variableVariabilities == null) {
                    this.variableVariabilities = this.getAllVariableVariabilities_(this.getModelIDNew(), new int[this.variableNames.length]);
                }
                return this.variableVariabilities;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int[] getAllVariableVariabilities_(int var1, int[] var2);

    public String[] getAllDeclaredTypes() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypes == null) {
                    this.declaredTypes = this.getAllDeclaredTypes_(this.getModelIDNew());
                }
                return this.declaredTypes;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypes_(int var1);

    public String[] getAllDeclaredTypeDescriptions() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypeDescriptions == null) {
                    this.declaredTypeDescriptions = this.getAllDeclaredTypeDescriptions_(this.getModelIDNew());
                }
                return this.declaredTypeDescriptions;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypeDescriptions_(int var1);

    public String[] getAllDeclaredTypeQuantities() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypeQuantities == null) {
                    this.declaredTypeQuantities = this.getAllDeclaredTypeQuantities_(this.getModelIDNew());
                }
                return this.declaredTypeQuantities;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypeQuantities_(int var1);

    public String[] getAllDeclaredTypeUnits() throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.declaredTypeUnits == null) {
                    this.declaredTypeUnits = this.getAllDeclaredTypeUnits_(this.getModelIDNew());
                }
                return this.declaredTypeUnits;
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String[] getAllDeclaredTypeUnits_(int var1);

    public double getRealValue(String name) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        double result = this.getRealValue(key);
        return result;
    }

    public double getRealValue(int variableReference) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getRealValue_(this.getModelIDNew(), variableReference);
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native double getRealValue_(int var1, int var2) throws FMILException;

    public int getIntegerValue(String name) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        int result = this.getIntegerValue(key);
        return result;
    }

    public int getIntegerValue(int variableReference) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getIntegerValue_(this.getModelIDNew(), variableReference);
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native int getIntegerValue_(int var1, int var2) throws FMILException;

    public boolean getBooleanValue(String name) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        boolean result = this.getBooleanValue(key);
        return result;
    }

    public boolean getBooleanValue(int variableReference) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getBooleanValue_(this.getModelIDNew(), variableReference);
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native boolean getBooleanValue_(int var1, int var2) throws FMILException;

    public String getStringValue(String name) throws FMILException {
        int key = this.variableMap.get((Object)name);
        if (key == NO_VARIABLE_KEY) {
            throw new FMILException("No variable with name " + name);
        }
        String result = this.getStringValue(key);
        return result;
    }

    public String getStringValue(int variableReference) throws FMILException {
        Object object = syncObject;
        synchronized (object) {
            try {
                return this.getStringValue_(this.getModelIDNew(), variableReference);
            }
            catch (UnsatisfiedLinkError err) {
                throw new FMILException(UNSATISFIED_LINK);
            }
            catch (Exception e) {
                throw new FMILException(e.getMessage());
            }
        }
    }

    private native String getStringValue_(int var1, int var2) throws FMILException;

    private boolean lockFMUDirectory() {
        try {
            File lockFile = new File(this.TEMP_FMU_DIRECTORY, LOCK_FILE_NAME);
            if (!lockFile.isFile()) {
                lockFile.createNewFile();
            }
            this.channel = new RandomAccessFile(lockFile, "rw").getChannel();
            this.lock = this.channel.lock();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean unlockFMUDirectory() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean removeFMUDirectoryContents() {
        try {
            File tempDir = new File(this.TEMP_FMU_DIRECTORY);
            FileUtils.deleteAll((File)tempDir);
            tempDir.delete();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.unloadFMU();
            }
            catch (Throwable t) {
                LOGGER.error("Could not unload native FMU!", t);
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }
}

