/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.workbench;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.part.IPageSite;
import org.simantics.utils.ui.SWTUtils;

public class WorkbenchUtils {
    public static IViewPart findView(String primaryID, String secondaryID) {
        if (secondaryID == null) {
            return WorkbenchUtils._findView(primaryID, false);
        }
        return WorkbenchUtils._findView(String.valueOf(primaryID) + ":" + secondaryID, false);
    }

    public static IViewPart findView(String id) {
        return WorkbenchUtils._findView(id, false);
    }

    public static IViewPart[] findAllViews(String primaryId) {
        ArrayList<IViewPart> result = new ArrayList<IViewPart>();
        IViewReference[] iViewReferenceArray = WorkbenchUtils.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (primaryId.equals(ref.getId())) {
                result.add(ref.getView(true));
            }
            ++n2;
        }
        return result.toArray(new IViewPart[0]);
    }

    public static IViewPart getView(String id) {
        return WorkbenchUtils._findView(id, true);
    }

    public static IWorkbenchWindow getWorkbenchWindow(Shell shell) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            if (w.getShell() == shell) {
                return w;
            }
            ++n2;
        }
        return null;
    }

    public static Shell getActiveWorkbenchWindowShell() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static IWorkbenchPart getActiveWorkbenchPart() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow wbw = wb.getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage wbp = wbw.getActivePage();
        if (wbp == null) {
            return null;
        }
        return wbp.getActivePart();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow wbw = wb.getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage wbp = wbw.getActivePage();
        if (wbp == null) {
            return null;
        }
        return wbp.getActiveEditor();
    }

    public static IPerspectiveDescriptor getCurrentPerspective() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow wbw = wb.getActiveWorkbenchWindow();
        if (wbw == null) {
            return null;
        }
        IWorkbenchPage wbp = wbw.getActivePage();
        if (wbp == null) {
            return null;
        }
        return wbp.getPerspective();
    }

    public static String getCurrentPerspectiveId() {
        IPerspectiveDescriptor p = WorkbenchUtils.getCurrentPerspective();
        if (p == null) {
            return null;
        }
        return p.getId();
    }

    public static IViewReference[] getViewReferences() {
        HashSet<IViewReference> result = new HashSet<IViewReference>();
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            if (wb == null) {
                return null;
            }
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null) {
                return null;
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page != null) {
                    IViewReference[] refs;
                    IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
                    int n5 = refs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IViewReference ref = iViewReferenceArray[n6];
                        result.add(ref);
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IViewReference[0]);
    }

    public static IViewReference[] getViewReferences(IWorkbenchWindow window) {
        HashSet<IViewReference> result = new HashSet<IViewReference>();
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] refs;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference ref = iViewReferenceArray[n4];
                result.add(ref);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IViewReference[0]);
    }

    public static IViewPart getView(String primaryID, String secondaryID) {
        if (secondaryID == null) {
            return WorkbenchUtils._findView(primaryID, true);
        }
        return WorkbenchUtils._findView(String.valueOf(primaryID) + ":" + secondaryID, true);
    }

    private static IViewPart _findView(String id, boolean restore) {
        String primaryId = WorkbenchUtils.getPrimaryID(id);
        String secondaryId = WorkbenchUtils.getSecondaryID(id);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            if (wb == null) {
                return null;
            }
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null) {
                return null;
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewPart vp;
                IViewReference vr;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page != null && (vr = page.findViewReference(primaryId, secondaryId)) != null && (vp = vr.getView(restore)) != null) {
                    return vp;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static boolean hideView(String id) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return false;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            if (wb == null) {
                return false;
            }
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null) {
                return false;
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference vr;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page != null && (vr = page.findViewReference(WorkbenchUtils.getPrimaryID(id), WorkbenchUtils.getSecondaryID(id))) != null) {
                    page.hideView(vr);
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hideView(IViewPart viewPart) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return false;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            if (wb == null) {
                return false;
            }
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null) {
                return false;
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page != null) {
                    page.hideView(viewPart);
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hideView(IWorkbenchWindow window, IViewPart view) {
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            if (page != null) {
                page.hideView(view);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hideView(IWorkbenchWindow window, IViewReference view) {
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            if (page != null) {
                page.hideView(view);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getPrimaryID(String id) {
        String[] splitted = id.split(":");
        if (splitted == null || splitted.length < 1) {
            return null;
        }
        return splitted[0];
    }

    public static String getSecondaryID(String id) {
        String[] splitted = id.split(":");
        if (splitted == null || splitted.length < 2) {
            return null;
        }
        return splitted[1];
    }

    public static IViewPart showView(String id) throws PartInitException {
        return WorkbenchUtils.showView(id, 3);
    }

    public static IViewPart activateView(String id) throws PartInitException {
        IViewPart vp = WorkbenchUtils.showView(id, 1);
        return vp;
    }

    public static IViewPart showView(String id, final int mode) throws PartInitException {
        IViewPart vp = WorkbenchUtils.findView(id);
        if (vp != null) {
            if (mode == 3) {
                return vp;
            }
            Display display = Display.getCurrent();
            if (Thread.currentThread() == display.getThread()) {
                IWorkbenchPage page = vp.getViewSite().getPage();
                if (mode == 2) {
                    page.bringToTop((IWorkbenchPart)vp);
                } else if (mode == 1) {
                    page.activate((IWorkbenchPart)vp);
                }
            } else {
                final IViewPart fvp = vp;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow wb = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage page = wb.getActivePage();
                        if (mode == 2) {
                            page.bringToTop((IWorkbenchPart)fvp);
                        } else {
                            page.activate((IWorkbenchPart)fvp);
                        }
                    }
                });
            }
            return vp;
        }
        String primaryID = WorkbenchUtils.getPrimaryID(id);
        String secondaryID = WorkbenchUtils.getSecondaryID(id);
        if (primaryID == null) {
            return null;
        }
        IWorkbenchWindow wb = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wb == null) {
            return null;
        }
        IWorkbenchPage page = wb.getActivePage();
        if (page == null) {
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null || pages.length == 0) {
                return null;
            }
            page = pages[0];
        }
        vp = page.showView(primaryID, secondaryID, mode);
        return vp;
    }

    public static void showPerspective(String perspectiveId) throws WorkbenchException {
        WorkbenchUtils.showPerspective(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), perspectiveId);
    }

    public static void showPerspective(IWorkbenchWindow window, String perspectiveId) throws WorkbenchException {
        PlatformUI.getWorkbench().showPerspective(perspectiveId, window);
    }

    public static void showPerspective(IWorkbenchWindow window, String perspectiveId, IAdaptable input) throws WorkbenchException {
        PlatformUI.getWorkbench().showPerspective(perspectiveId, window, input);
    }

    public static void closeFilteredPerspectives(IFilter perspectiveFilter) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            WorkbenchUtils.closeFilteredPerspectives(window, perspectiveFilter);
            ++n2;
        }
    }

    public static void closeFilteredPerspectives(IWorkbenchWindow window, IFilter perspectiveFilter) {
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IPerspectiveDescriptor[] iPerspectiveDescriptorArray = page.getOpenPerspectives();
            int n3 = iPerspectiveDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPerspectiveDescriptor desc = iPerspectiveDescriptorArray[n4];
                if (!perspectiveFilter.select((Object)desc)) {
                    page.closePerspective(desc, true, false);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static IActionBars getActionBars(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            return ((IViewPart)part).getViewSite().getActionBars();
        }
        if (part instanceof IEditorPart) {
            return ((IEditorPart)part).getEditorSite().getActionBars();
        }
        throw new IllegalArgumentException("Specified IWorkbenchPart is neither IViewPart nor IEditorPart");
    }

    public static IEditorPart openEditor(String editorId, IEditorInput input) throws PartInitException {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
        if (desc == null) {
            throw new IllegalArgumentException("editor with id '" + editorId + "' not found");
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            throw new IllegalStateException("active workbench window is null");
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            throw new IllegalStateException("active workbench page is null");
        }
        return page.openEditor(input, desc.getId());
    }

    public static void openEditorInPerspective(String editorId, IEditorInput input, String perspectiveId) throws Exception {
        WorkbenchUtils.showPerspective(perspectiveId);
        WorkbenchUtils.openEditor(editorId, input);
    }

    public static boolean closeAllEditors(boolean save) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return false;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            if (wb == null) {
                return false;
            }
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null) {
                return false;
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page != null) {
                    return page.closeAllEditors(save);
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean closeEditor(IEditorPart editorPart, boolean save) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows == null) {
            return false;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wb = iWorkbenchWindowArray[n2];
            if (wb == null) {
                return false;
            }
            IWorkbenchPage[] pages = wb.getPages();
            if (pages == null) {
                return false;
            }
            IWorkbenchPage[] iWorkbenchPageArray = pages;
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page != null) {
                    return page.closeEditor(editorPart, save);
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean closeEditors(IWorkbenchWindow window, boolean save) {
        boolean result = true;
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            if (page != null) {
                result &= page.closeAllEditors(false);
            }
            ++n2;
        }
        return result;
    }

    public static IActionBars getActionBars(IWorkbenchSite site) {
        if (site instanceof IViewSite) {
            return ((IViewSite)site).getActionBars();
        }
        if (site instanceof IPageSite) {
            return ((IPageSite)site).getActionBars();
        }
        if (site instanceof IEditorSite) {
            return ((IEditorSite)site).getActionBars();
        }
        if (site instanceof IIntroSite) {
            return ((IIntroSite)site).getActionBars();
        }
        return null;
    }

    public static IStatusLineManager getStatusLine(IWorkbenchPart part) {
        IActionBars bars = WorkbenchUtils.getActionBars(part);
        return bars != null ? bars.getStatusLineManager() : null;
    }

    public static IStatusLineManager getStatusLine(IWorkbenchSite site) {
        IActionBars bars = WorkbenchUtils.getActionBars(site);
        return bars != null ? bars.getStatusLineManager() : null;
    }

    public static boolean activatePart(final IWorkbenchPartSite partSite) {
        final IWorkbenchPart part = partSite.getPart();
        IWorkbench workbench = partSite.getWorkbenchWindow().getWorkbench();
        Display display = workbench.getDisplay();
        Runnable activator = new Runnable(){

            @Override
            public void run() {
                partSite.getPage().activate(part);
            }
        };
        if (Thread.currentThread() == display.getThread()) {
            activator.run();
            return true;
        }
        SWTUtils.asyncExec((Display)display, (Runnable)activator);
        return false;
    }
}

