package org.simantics.ui.workspace.tracker.internal;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.filesystem.services.sizetracker.DirectorySizeService;
import org.simantics.ui.workspace.tracker.IWorkspaceSizeTrackerConstants;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class Activator implements BundleActivator {

	private static Activator instance;
	private static BundleContext context;
	private ServiceTracker<DirectorySizeService, DirectorySizeService> tracker;
	private IPreferenceStore preferenceStore;

	static BundleContext getContext() {
		return context;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext bundleContext) throws Exception {
		Activator.instance = this;
		Activator.context = bundleContext;
		tracker = new ServiceTracker<>(bundleContext, DirectorySizeService.class, null);
		tracker.open();
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext bundleContext) throws Exception {
		tracker.close();
		Activator.context = null;
		Activator.instance = null;
	}

	/**
	 * @return <code>null</code> if service is no longer available
	 */
	public DirectorySizeService getDirectorySizeService() {
		return tracker.getService();
	}

	public BundleContext getBundleContext() {
		return context;
	}

	public IPreferenceStore getPreferenceStore() {
		if (preferenceStore == null) {
			preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, IWorkspaceSizeTrackerConstants.P_NODE);
		}
		return preferenceStore;
	}

	public static Activator getDefault() {
		return instance;
	}

}
