package org.simantics.tests.modelled.ui.rules;

import java.util.Collections;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.tests.modelled.ui.ontology.TestsUIResource;

public class TestImageRule implements ImageRule {

    private ImageDescriptor testImage;
    private ImageDescriptor testIgnoredImage;

    public TestImageRule(ReadGraph graph) throws DatabaseException {
        TestsUIResource TESTS = TestsUIResource.getInstance(graph);
        testImage = graph.adapt(TESTS.testImage, ImageDescriptor.class);
        testIgnoredImage = graph.adapt(TESTS.testIgnoredImage, ImageDescriptor.class);
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return Resource.class.equals(contentType);
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource resource = (Resource) content;
        Boolean ignored = graph.getPossibleRelatedValue2(resource, TestsResource.getInstance(graph).ignore,
                Bindings.BOOLEAN);
        if (ignored != null && ignored)
            return Collections.singletonMap(ColumnKeys.SINGLE, testIgnoredImage);
        return Collections.singletonMap(ColumnKeys.SINGLE, testImage);
    }

}
