package org.simantics.tests.modelled.ui;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditorDocumentProvider;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;

@Deprecated
public class STSTestEditorDocumentProvider extends SCLModuleEditorDocumentProvider {

    public STSTestEditorDocumentProvider(SCLSourceViewerConfigurationNew sourceViewer) {
        super(sourceViewer);
    }
    
    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        resource = input.getResource();
        try {
            return Simantics.getSession().syncRequest(new UniqueRead<Document>() {
                @Override
                public Document perform(ReadGraph graph) throws DatabaseException {
                    TestsResource TESTS = TestsResource.getInstance(graph);
                    currentText = graph.getRelatedValue(resource, TESTS.STSTest_definition, Bindings.STRING);
                    errorHappened = false;
                    return new Document(currentText != null ? currentText : "");
                }
            });
        } catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            errorHappened = true;
            return new Document(sw.toString());
        }
    }
    
    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog("STSTestEditorDocumentProvider.doSaveDocument");
        currentText = document.get();
        Simantics.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                TestsResource TESTS = TestsResource.getInstance(graph);
                graph.claimLiteral(resource, TESTS.STSTest_definition, currentText, Bindings.STRING);
                Layer0Utils.addCommentMetadata(graph, "Saved SCL Module " + graph.getRelatedValue2(resource, Layer0.getInstance(graph).HasName, Bindings.STRING));
            }
        });
    }

}
