package org.simantics.spreadsheet.synchronization;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.solver.SpreadsheetStyle;

public class LineContentBeanCell {

    public static final Variant EMPTY = new Variant();

    public Variant content;
    public final int styleID;

    public LineContentBeanCell() {
        this(SpreadsheetStyle.empty().getStyleId());
    }

    public LineContentBeanCell(int styleId) {
        this(EMPTY, styleId);
    }

    public LineContentBeanCell(Variant content, int styleId) {
        this.content = content;
        this.styleID = styleId;
    }

    public Variant getContent() {
        return content;
    }

    public void setContent(Variant content) {
        this.content = content;
    }

    public int getStyleId() {
        return styleID;
    }
}
