package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class OrFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 0) throw new IllegalStateException();

        for (int i = 0; i < args.values.size(); i++) {
            Object obj = null;
            try {
                obj = args.values.get(i).accept(visitor);
            } catch (IllegalStateException e){
                return FormulaError2.NAME.getString();
            }
            FormulaError2 error = FormulaError2.forObject(obj);
            if(error!=null) return error.getString();

            if (Spreadsheets.asBoolean(obj))
                return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

}
