package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstNothing;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;

public class IfFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 3) throw new IllegalStateException();

        Object condition = args.values.get(0).accept(visitor);
        AstValue ifTrueResult = args.values.get(1);
        AstValue ifFalseResult = args.values.get(2);

        FormulaError2 error = FormulaError2.forObject(condition);
        if(error!=null) return error.getString();

        if (Spreadsheets.asBoolean(condition)) {
            if(ifTrueResult==null || ifTrueResult instanceof AstNothing)
                return 0;
            try {
                return ifTrueResult.accept(visitor);
            } catch (IllegalStateException e){
                return FormulaError2.NAME.getString();
            }
        }
        else {
            if(ifFalseResult==null || ifFalseResult instanceof AstNothing)
                return 0;
            try {
                return ifFalseResult.accept(visitor);
            } catch (IllegalStateException e){
                return FormulaError2.NAME.getString();
            }
        }
    }
}