package org.simantics.spreadsheet.solver;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;

import org.simantics.spreadsheet.SpreadsheetVisitable;

public interface SpreadsheetElement<Child extends SpreadsheetElement<?, ?>, Parent extends SpreadsheetElement<?, ?>> extends SpreadsheetVisitable, Serializable {

    Optional<Parent> getParent();

    Collection<Child> getSpreadsheetChildren();

    void remove(Child child);

}
