package org.simantics.spreadsheet.solver;

import java.util.Collections;
import java.util.Map;

@SuppressWarnings("rawtypes")
public class SpreadsheetCellContent implements SheetNode {

    private static final long serialVersionUID = 6463195673537211769L;
    
    public final SpreadsheetCell cell;

    public SpreadsheetCellContent(SpreadsheetCell cell) {
        this.cell = cell;
    }

    @Override
    public String getName() {
        return "content";
    }

    @Override
    public Map getChildren() {
        return Collections.emptyMap();
    }

    @Override
    public Map getProperties() {
        if(cell.hasExpression()) {
            return Collections.singletonMap("expression", new SpreadsheetCellContentExpression(cell));
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((cell == null) ? 0 : cell.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetCellContent other = (SpreadsheetCellContent) obj;
        if (cell == null) {
            if (other.cell != null)
                return false;
        } else if (!cell.equals(other.cell))
            return false;
        return true;
    }

}
