/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment.filter;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;

public class NegativeNamespaceFilter
implements NamespaceFilter {
    THashSet<String> excludedValues;

    public NegativeNamespaceFilter(THashSet<String> excludedValues) {
        this.excludedValues = excludedValues;
    }

    @Override
    public boolean isValueIncluded(String name) {
        return !this.excludedValues.contains((Object)name);
    }

    public String toString() {
        return "Exclude" + this.excludedValues.toString();
    }

    @Override
    public boolean isSubsetOf(NamespaceFilter filter) {
        if (filter == AcceptAllNamespaceFilter.INSTANCE) {
            return true;
        }
        if (filter instanceof NegativeNamespaceFilter) {
            NegativeNamespaceFilter other = (NegativeNamespaceFilter)filter;
            for (String name : other.excludedValues) {
                if (this.excludedValues.contains((Object)name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

