/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Deque;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.Resource;
import org.simantics.db.layer0.migration.MigratedImportResult;
import org.simantics.db.management.ISessionContext;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.modeling.ui.sharedontology.wizard.ImportPlan;
import org.simantics.modeling.ui.sharedontology.wizard.ModelImportPage;
import org.simantics.modeling.ui.sharedontology.wizard.ModelImporter;
import org.simantics.modeling.ui.sharedontology.wizard.Preferences;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.utils.strings.EString;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.dialogs.InfoDialog;

public class ModelImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    ImportPlan importModel;

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return false;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return false;
        }
        this.importModel = new ImportPlan(ctx, recentImportPaths);
        this.importModel.project = project;
        this.importModel.selection = selection.getFirstElement();
        this.importModel.includeDependencies = store.getBoolean("IMPORT_INCLUDE_DEPENDENCIES");
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.recentLocations));
        store.setValue("IMPORT_INCLUDE_DEPENDENCIES", this.importModel.includeDependencies);
        if (store.needsSaving()) {
            store.save();
        }
    }

    public ModelImportWizard() {
        this.setWindowTitle("Import Model");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new ModelImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import Model"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.recentLocations.addFirst(this.importModel.importLocation.getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.recentLocations);
            if (this.importModel.recentLocations.size() > 10) {
                this.importModel.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            MigratedImportResult[] result = new MigratedImportResult[1];
            this.getContainer().run(true, true, monitor -> {
                try {
                    try {
                        Resource target = Simantics.getProjectResource();
                        this.importModel.sessionContext.getSession().markUndoPoint();
                        migratedImportResultArray[0] = ModelImporter.doImport(monitor, this.importModel.importLocation, this.importModel.sessionContext.getSession(), target, this.importModel.includeDependencies);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
            if (result[0].hasMissingExternals()) {
                InfoDialog.open((Shell)this.getShell(), (String)"Missing Externals Created", (String)("The system was unable to find some of the external entities referenced by the imported material. Place-holders have been created for the missing entities.\nThe missing entities are:\n" + URIStringUtils.unescape((String)EString.implode((Collection)result[0].tgResult.missingExternals))), (int)0x10000000);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (cause instanceof MissingDependencyException) {
                cp.setErrorMessage("Failed to import model due to missing dependencies.\n" + cause.getMessage());
                ErrorLogger.defaultLogError((String)("Model " + this.importModel.importLocation + " import failed due to missing database dependencies. See exception for details."), (Throwable)cause);
                ExceptionUtils.showError((String)("Failed to import model due to missing dependencies.\n\n" + cause.getMessage()), null);
            } else {
                cp.setErrorMessage("Unexpected problem importing model.\nMessage: " + cause.getMessage());
                ErrorLogger.defaultLogError((String)("Model " + this.importModel.importLocation + " import failed unexpectedly. See exception for details."), (Throwable)cause);
                ExceptionUtils.showError((String)("Unexpected problem importing model.\n\n" + cause.getMessage()), (Throwable)cause);
            }
            return false;
        }
        catch (InterruptedException e) {
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage("Import interrupted.\nMessage: " + e.getMessage());
            ErrorLogger.defaultLogError((String)("Model " + this.importModel.importLocation + " import interrupted."), (Throwable)e);
            ExceptionUtils.showError((String)"Model import was interrupted.", (Throwable)e);
            return false;
        }
        return true;
    }
}

