/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import com.kitfox.svg.SVGCache;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentSettings;
import org.simantics.document.DocumentUtils;
import org.simantics.export.core.pdf.FontMapping;
import org.simantics.export.core.pdf.PageNumbering;
import org.simantics.export.core.pdf.ServiceBasedPdfExportPageEvent;
import org.simantics.modeling.requests.CollectionRequest;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.modeling.ui.pdf.PDFPainter;
import org.simantics.modeling.ui.pdf.PdfException;
import org.simantics.modeling.ui.preferences.DiagramPreferenceUtil;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.WorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramPrinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagramPrinter.class);

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static CollectionResult browse(IProgressMonitor monitor, RequestProcessor processor, Resource[] input) throws DatabaseException {
        CollectionResult result = (CollectionResult)processor.syncRequest((Read)new CollectionRequest(monitor, DiagramPreferenceUtil.getDefaultPreferences().getCompletePageDesc(), input));
        return result;
    }

    public static void printToPdf(IProgressMonitor monitor, PDFExportPlan exportPlan, String exportPath, Collection<Node> flattenedNodes) throws PdfException {
        if (!exportPlan.addPageNumbers) {
            DiagramPrinter.printToPdfWithoutPageNumbers(monitor, exportPlan, exportPath, flattenedNodes);
        } else {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export to PDF", (int)(flattenedNodes.size() * 3));
            Path tempOutput = Paths.get(String.valueOf(exportPath) + ".tmp", new String[0]);
            Path finalOutput = Paths.get(exportPath, new String[0]);
            int exportedPages = DiagramPrinter.printToPdfWithoutPageNumbers((IProgressMonitor)mon.newChild(flattenedNodes.size() * 2, 0), exportPlan, tempOutput.toString(), flattenedNodes);
            if (mon.isCanceled()) {
                tempOutput.toFile().delete();
                throw new OperationCanceledException();
            }
            try {
                try {
                    mon.setWorkRemaining(exportedPages);
                    mon.setTaskName("Numbering output pages");
                    mon.subTask("");
                    PageNumbering.addPageNumbers((IProgressMonitor)mon.newChild(flattenedNodes.size()), (Path)tempOutput, (Path)finalOutput, (PageNumbering.Position)exportPlan.pageNumberPosition, (PageNumbering.NumberingFormat)exportPlan.pageNumberFormat);
                }
                catch (DocumentException | ExceptionConverter | IOException e) {
                    throw new PdfException(e);
                }
            }
            finally {
                tempOutput.toFile().delete();
            }
        }
    }

    public static int printToPdfWithoutPageNumbers(IProgressMonitor monitor, PDFExportPlan exportPlan, String exportPath, Collection<Node> flattenedNodes) throws PdfException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export to PDF", (int)(flattenedNodes.size() * 2));
        WorkerThread workerThread = new WorkerThread("Diagram PDF Painter");
        workerThread.start();
        PdfWriter writer = null;
        Document document = null;
        int exportedPages = 0;
        try {
            progress.subTask("Loading system fonts");
            FontMapper mapper = FontMapping.defaultFontMapper();
            SessionGarbageCollectorJob.getInstance().setEnabled(false);
            boolean first = true;
            int i = 0;
            for (Node d : flattenedNodes) {
                ++i;
                Rectangle pageSize = DiagramPrinter.toPageSize(d.getPageDesc());
                if (writer == null) {
                    document = new Document(pageSize);
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(exportPath));
                    writer.setPdfVersion(PdfWriter.PDF_VERSION_1_7);
                    writer.setPageEvent((PdfPageEvent)new ServiceBasedPdfExportPageEvent());
                    if (exportPlan.attachTG) {
                        writer.addViewerPreference(PdfName.USEATTACHMENTS, (PdfObject)PdfBoolean.PDFTRUE);
                    }
                    String creator = DiagramPrinter.getCreator();
                    document.addCreator(creator);
                    document.open();
                }
                if (!first) {
                    document.setPageSize(pageSize);
                    document.newPage();
                }
                String diagramName = DiagramPrinter.formDiagramName(d, true);
                String subTask = "Page (" + i + "/" + flattenedNodes.size() + "): " + diagramName;
                Resource diagram = d.getDiagramResource();
                if (diagram == null) {
                    subTask = String.valueOf(subTask) + " skipped, no diagram.";
                    LOGGER.info(subTask);
                    continue;
                }
                LOGGER.info(subTask);
                progress.subTask(subTask);
                try {
                    PDFPainter.render((IThreadWorkQueue)workerThread, exportPlan, d, writer, mapper, pageSize, d.getPageDesc(), exportPlan.fitContentToPageMargins, 10000L);
                    ++exportedPages;
                }
                catch (InterruptedException | DatabaseException e) {
                    LOGGER.error("PDF rendering failed.", e);
                }
                if (exportPlan.attachWiki && !d.getDefiningResources().isEmpty()) {
                    int w = (int)pageSize.getWidth();
                    int h = (int)pageSize.getHeight();
                    PdfContentByte cb = writer.getDirectContent();
                    Session session = exportPlan.sessionContext.getSession();
                    Resource composite = (Resource)d.getDefiningResources().iterator().next();
                    DocumentUtils du = new DocumentUtils();
                    StringBuilder wiki = new StringBuilder();
                    StringBuilder css = new StringBuilder();
                    du.getDocumentWikiTextRecursive(session, composite, wiki, css);
                    DocumentSettings settings = du.getDocumentSettings((RequestProcessor)session, composite);
                    PdfTemplate tp_ = cb.createTemplate((float)w, (float)h);
                    if (wiki.length() > 0) {
                        String wikiText = wiki.toString();
                        String cssText = css.toString();
                        try {
                            exportedPages += du.print((RequestProcessor)session, composite, wikiText, cssText, settings, tp_.getPdfWriter(), document);
                        }
                        catch (DocumentException | DatabaseException e) {
                            LOGGER.error("Wiki documentation to PDF rendering failed.", e);
                        }
                    }
                    cb.addTemplate(tp_, 0.0f, 0.0f);
                }
                progress.worked(1);
                first = false;
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                LOGGER.trace("GC");
                SVGCache.getSVGUniverse().clearUnreferenced();
                SessionGarbageCollection.gc(null, (Session)exportPlan.sessionContext.getSession(), (boolean)true, null);
                System.gc();
                LOGGER.trace("GC finished");
                progress.worked(1);
            }
            int n = exportedPages;
            return n;
        }
        catch (DocumentException | ExceptionConverter | FileNotFoundException | DatabaseException e) {
            throw new PdfException(e);
        }
        finally {
            workerThread.stopDispatchingEvents(true);
            LOGGER.trace("closing document");
            try {
                if (document != null) {
                    document.close();
                }
                if (writer != null) {
                    writer.close();
                }
                LOGGER.trace("document closed");
            }
            catch (RuntimeException e) {
                LOGGER.error("Error closing PDF document writer", (Throwable)e);
            }
            SessionGarbageCollectorJob.getInstance().setEnabled(true).scheduleAfterQuietTime();
        }
    }

    public static Rectangle toPageSize(PageDesc pageDesc) {
        String arg = String.valueOf(PageDesc.toPoints((double)pageDesc.getWidth())) + " " + PageDesc.toPoints((double)pageDesc.getHeight());
        Rectangle r = PageSize.getRectangle((String)arg);
        if (PageOrientation.Landscape == pageDesc.getOrientation()) {
            r = r.rotate();
        }
        r.setBorder(0);
        return r;
    }

    public static String formDiagramName(Node node, boolean parents) {
        Node d = node;
        String ret = d.getName();
        if (parents) {
            while (d.getParent() != null) {
                d = d.getParent();
                ret = String.valueOf(d.getName()) + " / " + ret;
            }
        }
        return ret;
    }

    public static String getCreator() {
        String creator = null;
        IProduct product = Platform.getProduct();
        if (product != null && (creator = product.getDescription()) == null) {
            creator = product.getName();
        }
        if (creator == null) {
            creator = "Simantics";
        }
        return creator;
    }
}

