/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram;

import java.util.Arrays;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;

public final class ValueFormatUtil {
    static String valueStr(Object value_) {
        if (value_ == null) {
            return "<null>";
        }
        return ValueFormatUtil.valueStr(value_, MetricsFormatList.METRICS_GENERIC);
    }

    public static String valueStr(Object value_, MetricsFormat decimalFormat) {
        if (value_ == null) {
            return "<null>";
        }
        Class<?> clazz = value_.getClass();
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isPrimitive()) {
                if (double[].class == clazz) {
                    return ValueFormatUtil.formatDouble((double[])value_, decimalFormat);
                }
                if (float[].class == clazz) {
                    return ValueFormatUtil.formatFloat((float[])value_, decimalFormat);
                }
                if (boolean[].class == clazz) {
                    return ValueFormatUtil.formatBoolean((boolean[])value_);
                }
                if (int[].class == clazz) {
                    return ValueFormatUtil.formatInteger((int[])value_);
                }
                if (long[].class == clazz) {
                    return ValueFormatUtil.formatLong((long[])value_);
                }
                if (byte[].class == clazz) {
                    return ValueFormatUtil.formatByte((byte[])value_);
                }
                return value_.toString();
            }
            if (String[].class == clazz) {
                return ValueFormatUtil.formatString((String[])value_);
            }
            return value_.toString();
        }
        if (Double.class == clazz) {
            return ValueFormatUtil.formatDouble((Double)value_, decimalFormat);
        }
        if (Float.class == clazz) {
            return ValueFormatUtil.formatFloat(new float[]{((Float)value_).floatValue()}, decimalFormat);
        }
        return value_.toString();
    }

    private static String formatDouble(double[] ds, MetricsFormat f) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        double[] dArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(f.formatValue(d));
            ++n2;
        }
        return sb.toString();
    }

    private static String formatDouble(double d, MetricsFormat f) {
        return f.formatValue(d);
    }

    private static String formatFloat(float[] ds, MetricsFormat f) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        float[] fArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(f.formatValue((double)d));
            ++n2;
        }
        return sb.toString();
    }

    private static String formatString(String[] value) {
        if (value.length == 1) {
            return value[0];
        }
        return Arrays.toString(value);
    }

    private static String formatBoolean(boolean[] value) {
        if (value.length == 1) {
            return Boolean.toString(value[0]);
        }
        return Arrays.toString(value);
    }

    private static String formatInteger(int[] value) {
        if (value.length == 1) {
            return Integer.toString(value[0]);
        }
        return Arrays.toString(value);
    }

    private static String formatLong(long[] value) {
        if (value.length == 1) {
            return Long.toString(value[0]);
        }
        return Arrays.toString(value);
    }

    private static String formatByte(byte[] value) {
        if (value.length == 1) {
            return Byte.toString(value[0]);
        }
        return Arrays.toString(value);
    }
}

