/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.indexing;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Session;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.services.ServiceInitializer;

public class IndexedRelationsInitializer implements ServiceInitializer {

    @Override
    public IStatus initialize(Session s) {
        IndexedRelations srv = s.peekService(IndexedRelations.class);
        if (srv == null || srv.getClass() != IndexedRelations.class)
            s.registerService(IndexedRelations.class, new IndexedRelationsImpl());

        return Status.OK_STATUS;
    }

}
