/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.browsecontexts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.content.CompositeImageDecorator;
import org.simantics.browsing.ui.content.CompositeLabelDecorator;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContexts;
import org.simantics.browsing.ui.model.browsecontexts.ResolveActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.ResolveBrowseContext;
import org.simantics.browsing.ui.model.check.CheckedStateContribution;
import org.simantics.browsing.ui.model.children.ChildContribution;
import org.simantics.browsing.ui.model.imagedecorators.ImageDecorationContribution;
import org.simantics.browsing.ui.model.images.ImageContribution;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationContribution;
import org.simantics.browsing.ui.model.labels.LabelContribution;
import org.simantics.browsing.ui.model.modifiers.ModifierContribution;
import org.simantics.browsing.ui.model.modifiers.NoModifierRule;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeTypeMultiMap;
import org.simantics.browsing.ui.model.nodetypes.OrderedNodeTypeMultiMap;
import org.simantics.browsing.ui.model.nodetypes.SpecialNodeType;
import org.simantics.browsing.ui.model.sorters.AlphanumericSorter;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterContribution;
import org.simantics.browsing.ui.model.tooltips.TooltipContribution;
import org.simantics.browsing.ui.model.visuals.FlatNodeContribution;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.viewpoint.ontology.ViewpointResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowseContext.class);
    public static final boolean DEBUG = false;
    NodeTypeMultiMap<ChildContribution> childContributions = new NodeTypeMultiMap();
    NodeTypeMultiMap<ChildContribution> parentContributions = new NodeTypeMultiMap();
    OrderedNodeTypeMultiMap<LabelContribution> labelContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<ImageContribution> imageContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<CheckedStateContribution> checkedStateContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<LabelDecorationContribution> labelDecorationContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<ImageDecorationContribution> imageDecorationContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<ModifierContribution> modifierContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<SorterContribution> sorterContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<FlatNodeContribution> flatNodeContributions = new OrderedNodeTypeMultiMap();
    OrderedNodeTypeMultiMap<TooltipContribution> tooltipContributions = new OrderedNodeTypeMultiMap();
    private final String[] uris;

    private BrowseContext(String ... uris) {
        if (uris == null) {
            throw new NullPointerException("null URIs");
        }
        this.uris = uris;
    }

    public String[] getURIs() {
        return this.uris;
    }

    public static BrowseContext get(ReadGraph graph, NodeContext context, BrowseContext defaultContext, boolean useNodeBrowseContexts) throws DatabaseException {
        if (!useNodeBrowseContexts) {
            return defaultContext;
        }
        BrowseContext mbc = (BrowseContext)graph.syncRequest((Read)new ResolveBrowseContext(context));
        if (mbc != null) {
            return mbc;
        }
        BrowseContext parentContext = (BrowseContext)context.getConstant(BuiltinKeys.BROWSE_CONTEXT);
        if (parentContext != null) {
            return parentContext;
        }
        return defaultContext;
    }

    private static BrowseContext loadCachedVisuals(final ReadGraph g, final Resource visualsContributionResource) throws DatabaseException, InvalidContribution {
        try {
            return (BrowseContext)g.syncRequest((Read)new ResourceRead<BrowseContext>(visualsContributionResource){

                public BrowseContext perform(ReadGraph graph) throws DatabaseException {
                    try {
                        BrowseContext bc = new BrowseContext(new String[0]);
                        VisualsContribution.load(g, visualsContributionResource, bc.labelContributions, bc.imageContributions, bc.checkedStateContributions, bc.labelDecorationContributions, bc.imageDecorationContributions, bc.modifierContributions, bc.sorterContributions, bc.flatNodeContributions, bc.tooltipContributions);
                        return bc;
                    }
                    catch (InvalidContribution e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            }, (AsyncProcedure)TransientCacheAsyncListener.instance());
        }
        catch (DatabaseException e) {
            Throwable c = e.getCause();
            if (c instanceof InvalidContribution) {
                throw (InvalidContribution)c;
            }
            throw e;
        }
    }

    public static BrowseContext create(ReadGraph g, Collection<Resource> browseContextResources) throws DatabaseException, InvalidContribution {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        BrowseContext browseContext = new BrowseContext(BrowseContexts.toSortedURIs(g, browseContextResources));
        for (Resource browseContextResource : BrowseContext.findSubcontexts(g, browseContextResources)) {
            for (Resource childContributionResource : g.getObjects(browseContextResource, vr.BrowseContext_HasChildContribution)) {
                try {
                    ChildContribution contribution = ChildContribution.createCached(g, childContributionResource);
                    browseContext.childContributions.put(contribution.getParentNodeType(), contribution);
                    browseContext.parentContributions.put(contribution.getChildNodeType(), contribution);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to load child contribution " + NameUtils.getSafeName((ReadGraph)g, (Resource)childContributionResource), (Throwable)e);
                }
            }
            for (Resource visualsContributionResource : g.getObjects(browseContextResource, vr.BrowseContext_HasVisualsContribution)) {
                try {
                    BrowseContext visuals = BrowseContext.loadCachedVisuals(g, visualsContributionResource);
                    visuals.labelContributions.appendTo(browseContext.labelContributions);
                    visuals.imageContributions.appendTo(browseContext.imageContributions);
                    visuals.checkedStateContributions.appendTo(browseContext.checkedStateContributions);
                    visuals.labelDecorationContributions.appendTo(browseContext.labelDecorationContributions);
                    visuals.imageDecorationContributions.appendTo(browseContext.imageDecorationContributions);
                    visuals.modifierContributions.appendTo(browseContext.modifierContributions);
                    visuals.sorterContributions.appendTo(browseContext.sorterContributions);
                    visuals.flatNodeContributions.appendTo(browseContext.flatNodeContributions);
                    visuals.tooltipContributions.appendTo(browseContext.tooltipContributions);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to load visuals contribution " + NameUtils.getSafeName((ReadGraph)g, (Resource)visualsContributionResource), (Throwable)e);
                }
            }
        }
        return browseContext;
    }

    public static Set<String> getBrowseContextClosure(RequestProcessor processor, Set<String> browseContexts) throws DatabaseException {
        return (Set)processor.syncRequest((Read)new UnaryRead<Set<String>, Set<String>>(browseContexts){

            public Set<String> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> browseContextResources = new ArrayList<Resource>(((Set)this.parameter).size());
                for (String browseContext : (Set)this.parameter) {
                    try {
                        browseContextResources.add(graph.getResource(browseContext));
                    }
                    catch (ResourceNotFoundException e) {
                        LOGGER.error("Didn't find " + browseContext + " while loading model browser.", (Throwable)e);
                    }
                }
                Collection<Resource> allBrowseContextResources = BrowseContext.findSubcontexts(graph, browseContextResources);
                HashSet<String> result = new HashSet<String>();
                for (Resource r : allBrowseContextResources) {
                    result.add(graph.getURI(r));
                }
                return result;
            }
        }, (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    public static Collection<Resource> findSubcontexts(ReadGraph g, Collection<Resource> browseContexts) throws DatabaseException {
        return (Collection)g.syncRequest((Read)new UnaryRead<Collection<Resource>, Collection<Resource>>(browseContexts){

            public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                return BrowseContext.findSubcontexts0(graph, (Collection)this.parameter);
            }
        }, (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    private static Collection<Resource> findSubcontexts0(ReadGraph g, Collection<Resource> browseContexts) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        HashSet<Resource> result = new HashSet<Resource>(browseContexts);
        ArrayList<Resource> stack = new ArrayList<Resource>(browseContexts);
        while (!stack.isEmpty()) {
            Resource cur = stack.remove(stack.size() - 1);
            for (Resource sc : g.getObjects(cur, vr.BrowseContext_Includes)) {
                if (!result.add(sc)) continue;
                stack.add(sc);
            }
        }
        return result;
    }

    public Collection<NodeContext> getChildren(ReadGraph graph, NodeContext parent) throws DatabaseException {
        if (this.isFlattened(graph, parent)) {
            return Collections.emptyList();
        }
        return this.getChildrenImpl(graph, parent);
    }

    private Collection<NodeContext> getChildrenImpl(ReadGraph graph, NodeContext parent) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeContext> result = new ArrayList<NodeContext>();
        Collection<Object> contributions = this.childContributions.get(graph, nodeType);
        if (contributions.size() > 1) {
            HashMap<String, ChildContribution> contribs = new HashMap<String, ChildContribution>();
            for (ChildContribution contribution : contributions) {
                String identifier = contribution.getIdentifier();
                ChildContribution current = (ChildContribution)contribs.get(identifier);
                if (current != null && current.getPriority() > contribution.getPriority()) continue;
                contribs.put(identifier, contribution);
            }
            contributions = contribs.values();
        }
        for (Object contribution : contributions) {
            Collection<NodeContext> children = ((ChildContribution)contribution).getChildren(graph, parent);
            result.addAll(children);
        }
        if (!result.isEmpty()) {
            for (Object contribution : this.sorterContributions.get(graph, nodeType)) {
                Sorter sorter = ((SorterContribution)contribution).getSorter(graph, parent);
                if (sorter == null) continue;
                sorter.sort(graph, this, result);
                return result;
            }
            AlphanumericSorter.INSTANCE.sort(graph, this, result);
        }
        result = this.flatten(graph, result);
        return result;
    }

    private ArrayList<NodeContext> flatten(ReadGraph graph, ArrayList<NodeContext> result) throws DatabaseException {
        ArrayList<NodeContext> flattened = new ArrayList<NodeContext>();
        for (NodeContext node : result) {
            if (this.isFlattened(graph, node)) {
                flattened.add(node);
                flattened.addAll(this.getChildrenImpl(graph, node));
                continue;
            }
            flattened.add(node);
        }
        return flattened;
    }

    public static ArrayList<NodeContext> augment(ReadGraph graph, BrowseContext bc, Collection<NodeContext> contexts, boolean resolveABC) throws DatabaseException {
        ArrayList<NodeContext> result = new ArrayList<NodeContext>();
        for (NodeContext context : contexts) {
            ActionBrowseContext abc = null;
            if (resolveABC && (abc = (ActionBrowseContext)graph.syncRequest((Read)new ResolveActionBrowseContext(context))) == null) {
                abc = (ActionBrowseContext)context.getConstant(BuiltinKeys.ACTION_BROWSE_CONTEXT);
            }
            result.add(NodeContextBuilder.buildWithData(NodeType.KEY_SEQUENCE_EXT, (Object[])new Object[]{context.getConstant(BuiltinKeys.INPUT), context.getConstant(NodeType.TYPE), context.getConstant(BuiltinKeys.UI_CONTEXT), bc, abc}));
        }
        return result;
    }

    private boolean isFlattened(ReadGraph graph, NodeContext node) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, node);
        return nodeType != null && !this.flatNodeContributions.get(graph, nodeType).isEmpty();
    }

    public Collection<NodeContext> getParents(ReadGraph graph, NodeContext child) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, child);
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<NodeContext> result = new ArrayList<NodeContext>();
        for (ChildContribution contribution : this.parentContributions.get(graph, nodeType)) {
            result.addAll(contribution.getParents(graph, child));
        }
        return result;
    }

    public boolean hasChildren(ReadGraph graph, NodeContext parent) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return false;
        }
        for (ChildContribution contribution : this.childContributions.get(graph, nodeType)) {
            if (!contribution.hasChildren(graph, parent)) continue;
            return true;
        }
        return false;
    }

    private static NodeType getNodeType(ReadGraph graph, NodeContext parent) throws DatabaseException {
        NodeType nodeType = (NodeType)parent.getConstant(NodeType.TYPE);
        if (nodeType == null) {
            Object input = parent.getConstant(BuiltinKeys.INPUT);
            if (input instanceof Resource) {
                nodeType = EntityNodeType.getNodeTypeFor(graph, (Resource)input);
            } else if (input instanceof Variable) {
                String uri = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Modeling-0.0/ModelingBrowseContext/Variable");
                return new SpecialNodeType(graph.getResource(uri), Variable.class);
            }
        }
        return nodeType;
    }

    public Map<String, String> getLabel(ReadGraph graph, NodeContext parent) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return Collections.singletonMap("single", "ERROR (no node type)");
        }
        List contributions = this.labelContributions.get(graph, nodeType);
        for (LabelContribution contribution : contributions) {
            Map<String, String> label = contribution.getLabel(graph, parent);
            if (label == null) continue;
            return label;
        }
        return Collections.singletonMap("single", "(no label rule)");
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, NodeContext parent) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return Collections.emptyMap();
        }
        for (ImageContribution contribution : this.imageContributions.get(graph, nodeType)) {
            Map<String, ImageDescriptor> image = contribution.getImage(graph, parent);
            if (image == null) continue;
            return image;
        }
        return Collections.emptyMap();
    }

    public CheckedState getCheckedState(ReadGraph graph, NodeContext parent) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return CheckedState.NOT_CHECKED;
        }
        for (CheckedStateContribution contribution : this.checkedStateContributions.get(graph, nodeType)) {
            CheckedState state = contribution.getCheckedState(graph, parent);
            if (state == null) continue;
            return state;
        }
        return CheckedState.NOT_CHECKED;
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, NodeContext context) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, context);
        if (nodeType == null) {
            return CompositeLabelDecorator.ID;
        }
        ArrayList<LabelDecorator> decorators = new ArrayList<LabelDecorator>();
        for (LabelDecorationContribution contribution : this.labelDecorationContributions.get(graph, nodeType)) {
            LabelDecorator decorator = contribution.getLabelDecorator(graph, context);
            if (decorator == null) continue;
            decorators.add(decorator);
        }
        return CompositeLabelDecorator.create(decorators);
    }

    public ImageDecorator getImageDecorator(ReadGraph graph, NodeContext context) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, context);
        if (nodeType == null) {
            return CompositeImageDecorator.ID;
        }
        ArrayList<ImageDecorator> decorators = new ArrayList<ImageDecorator>();
        for (ImageDecorationContribution contribution : this.imageDecorationContributions.get(graph, nodeType)) {
            ImageDecorator decorator = contribution.getImageDecorator(graph, context);
            if (decorator == null) continue;
            decorators.add(decorator);
        }
        return CompositeImageDecorator.create(decorators);
    }

    public Labeler.Modifier getModifier(ReadGraph graph, NodeContext context, String columnKey) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, context);
        if (nodeType != null) {
            for (ModifierContribution contribution : this.modifierContributions.get(graph, nodeType)) {
                Labeler.Modifier modifier = contribution.getModifier(graph, context, columnKey);
                if (modifier == NoModifierRule.NO_MODIFIER) {
                    return null;
                }
                if (modifier == null) continue;
                return modifier;
            }
        }
        return null;
    }

    public TooltipContribution shouldCreateToolTip(ReadGraph graph, Event event, NodeContext context) throws DatabaseException {
        NodeType nodeType = BrowseContext.getNodeType(graph, context);
        if (nodeType != null) {
            for (TooltipContribution contribution : this.tooltipContributions.get(graph, nodeType)) {
                if (!contribution.shouldCreateToolTip(graph, context)) continue;
                return contribution;
            }
        }
        return null;
    }

    public Object getTooltip(TooltipContribution contribution, Object event, Object parent, NodeContext context) throws DatabaseException {
        Object tooltip = contribution.getTooltip(event, parent, context);
        if (tooltip != null) {
            return tooltip;
        }
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.uris);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowseContext other = (BrowseContext)obj;
        return Arrays.equals(this.uris, other.uris);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + Arrays.toString(this.uris);
    }
}

