/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.system.procs.Procs;
import com.impossibl.postgres.system.tables.PGTypeTable;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.io.IOException;

public class ArrayType
extends Type {
    private Type elementType;

    public ArrayType() {
    }

    public ArrayType(int id, String name, Short length, Byte alignment, Type.Category category, char delimeter, int arrayTypeId, String procName, Procs procs, FieldFormat preferredParameterFormat, FieldFormat preferredResultFormat, Type elementType) {
        super(id, name, "pg_catalog", length, alignment, category, Character.valueOf(delimeter), arrayTypeId, procs.loadNamedBinaryCodec(procName), procs.loadNamedTextCodec(procName), procs.loadModifierParserProc(procName), preferredParameterFormat, preferredResultFormat);
        this.elementType = elementType;
    }

    public ArrayType(int id, String name, Short length, Byte alignment, Type.Category category, char delimeter, int arrayTypeId, Procs procs, FieldFormat preferredParameterFormat, FieldFormat preferredResultFormat, Type elementType) {
        this(id, name, length, alignment, category, delimeter, arrayTypeId, "array_", procs, preferredParameterFormat, preferredResultFormat, elementType);
    }

    public ArrayType(int id, String name, String namespace, Short length, Byte alignment, Type.Category category, char delimeter, int arrayTypeId, Type.BinaryCodec binaryCodec, Type.TextCodec textCodec, Modifiers.Parser modifierParser, FieldFormat preferredParameterFormat, FieldFormat preferredResultFormat, Type elementType) {
        super(id, name, namespace, length, alignment, category, Character.valueOf(delimeter), arrayTypeId, binaryCodec, textCodec, modifierParser, preferredParameterFormat, preferredResultFormat);
        this.elementType = elementType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isParameterFormatSupported(FieldFormat format) {
        return this.elementType.isParameterFormatSupported(format);
    }

    @Override
    public boolean isResultFormatSupported(FieldFormat format) {
        return this.elementType.isResultFormatSupported(format);
    }

    @Override
    public Type unwrap() {
        return this.elementType;
    }

    @Override
    public void load(PGTypeTable.Row source, Registry registry) throws IOException {
        super.load(source, registry);
        this.elementType = registry.loadType(source.getElementTypeId());
    }
}

