/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.CopyFormat;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.ServerConnection;
import com.impossibl.postgres.protocol.ssl.SSLEngineFactory;
import com.impossibl.postgres.protocol.ssl.SSLMode;
import com.impossibl.postgres.protocol.v30.MessageDispatchHandler;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.SSLQueryRequest;
import com.impossibl.postgres.protocol.v30.ServerConnection;
import com.impossibl.postgres.protocol.v30.ServerConnectionShared;
import com.impossibl.postgres.protocol.v30.StartupRequest;
import com.impossibl.postgres.system.Configuration;
import com.impossibl.postgres.system.NoticeException;
import com.impossibl.postgres.system.ServerInfo;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.utils.Await;
import com.impossibl.postgres.utils.MD5Authentication;
import com.impossibl.postgres.utils.Nulls;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslHandler;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ServerConnectionFactory
implements com.impossibl.postgres.protocol.ServerConnectionFactory {
    private static final long DEFAULT_STARTUP_TIMEOUT = 60L;
    private static final long DEFAULT_SSL_TIMEOUT = 60L;

    @Override
    public ServerConnection connect(Configuration config, SocketAddress address, ServerConnection.Listener listener) throws IOException {
        SSLMode sslMode = config.getSetting(SystemSettings.SSL_MODE);
        return this.connect(config, sslMode, address, listener, 1);
    }

    private ServerConnection connect(Configuration config, SSLMode sslMode, SocketAddress address, ServerConnection.Listener listener, int attempt) throws IOException {
        try {
            CreatedChannel createdChannel = this.createChannel(address, config);
            ServerConnectionShared.Ref sharedRef = createdChannel.sharedRef;
            Channel channel = createdChannel.channelFuture.syncUninterruptibly().channel();
            if (sslMode != SSLMode.Disable && sslMode != SSLMode.Allow) {
                SSLQueryRequest sslQueryRequest = new SSLQueryRequest();
                channel.writeAndFlush((Object)sslQueryRequest).syncUninterruptibly();
                boolean sslQueryCompleted = Await.awaitUninterruptibly(60L, TimeUnit.SECONDS, sslQueryRequest::await);
                if (sslQueryCompleted && sslQueryRequest.isAllowed()) {
                    SSLEngine sslEngine = SSLEngineFactory.create(sslMode, config);
                    SslHandler sslHandler = new SslHandler(sslEngine);
                    channel.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
                    try {
                        sslHandler.handshakeFuture().syncUninterruptibly();
                    }
                    catch (Exception e) {
                        if (sslMode == SSLMode.Prefer) {
                            return this.connect(config, SSLMode.Disable, address, listener, attempt);
                        }
                        throw e;
                    }
                } else if (sslMode.isRequired()) {
                    throw new IOException("SSL not allowed by server");
                }
            }
            try {
                SslHandler sslHandler;
                HashMap<String, String> parameterStatuses = new HashMap<String, String>();
                ServerConnection serverConnection = ServerConnectionFactory.startup(config, channel, parameterStatuses, sharedRef);
                if (sslMode == SSLMode.VerifyFull && (sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class)) != null) {
                    String hostname = address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : "";
                    this.verifyHostname(hostname, sslHandler.engine().getSession());
                }
                serverConnection.getMessageDispatchHandler().setDefaultHandler(new DefaultHandler(listener));
                parameterStatuses.forEach(listener::parameterStatusChanged);
                return serverConnection;
            }
            catch (Exception e) {
                switch (sslMode) {
                    case Allow: {
                        return this.connect(config, SSLMode.Require, address, listener, attempt);
                    }
                    case Prefer: {
                        return this.connect(config, SSLMode.Disable, address, listener, attempt);
                    }
                }
                if (e instanceof ClosedChannelException && attempt < 2) {
                    return this.connect(config, sslMode, address, listener, attempt + 1);
                }
                throw e;
            }
        }
        catch (NoticeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ServerConnectionFactory.translateConnectionException(e);
        }
    }

    private CreatedChannel createChannel(SocketAddress address, Configuration config) {
        if (address instanceof InetSocketAddress) {
            return this.createInetSocketChannel((InetSocketAddress)address, config);
        }
        if (address instanceof DomainSocketAddress) {
            return this.createDomainSocketChannel((DomainSocketAddress)address, config);
        }
        throw new IllegalArgumentException("Unsupported socket address: " + address.getClass().getSimpleName());
    }

    private CreatedChannel createInetSocketChannel(InetSocketAddress address, Configuration config) {
        Class<OioEventLoopGroup> groupType;
        Class<OioSocketChannel> channelType;
        final int maxMessageSize = config.getSetting(SystemSettings.PROTOCOL_MESSAGE_SIZE_MAX);
        final Charset clientEncoding = config.getSetting(SystemSettings.PROTOCOL_ENCODING);
        int maxThreads = config.getSetting(SystemSettings.PROTOCOL_IO_THREADS);
        SystemSettings.ProtocolIOMode ioMode = config.getSetting(SystemSettings.PROTOCOL_IO_MODE);
        switch (ioMode) {
            case OIO: {
                channelType = OioSocketChannel.class;
                groupType = OioEventLoopGroup.class;
                maxThreads = 0;
                break;
            }
            case ANY: 
            case NATIVE: {
                if (KQueue.isAvailable()) {
                    channelType = KQueueSocketChannel.class;
                    groupType = KQueueEventLoopGroup.class;
                    break;
                }
                if (Epoll.isAvailable()) {
                    channelType = EpollSocketChannel.class;
                    groupType = EpollEventLoopGroup.class;
                    break;
                }
                if (ioMode != SystemSettings.ProtocolIOMode.ANY) {
                    throw new IllegalStateException("Unsupported io mode: native: no native library loaded");
                }
            }
            case NIO: {
                channelType = NioSocketChannel.class;
                groupType = NioEventLoopGroup.class;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported io mode: " + (Object)((Object)ioMode));
            }
        }
        ServerConnectionShared.Ref sharedRef = ServerConnectionShared.acquire(groupType, maxThreads);
        final Writer protocolTraceWriter = this.createProtocolTracer(config);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(sharedRef.get().getEventLoopGroup())).channel(channelType)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxMessageSize, 1, 4, -4, 0), new MessageDispatchHandler(clientEncoding, protocolTraceWriter)});
            }
        })).option(ChannelOption.TCP_NODELAY, (Object)true);
        this.configureChannelOptions(config, bootstrap);
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)address);
        return new CreatedChannel(sharedRef, channelFuture);
    }

    private CreatedChannel createDomainSocketChannel(DomainSocketAddress address, Configuration config) {
        Class<KQueueEventLoopGroup> groupType;
        Class<KQueueDomainSocketChannel> channelType;
        final int maxMessageSize = config.getSetting(SystemSettings.PROTOCOL_MESSAGE_SIZE_MAX);
        final Charset clientEncoding = config.getSetting(SystemSettings.PROTOCOL_ENCODING);
        if (KQueue.isAvailable()) {
            channelType = KQueueDomainSocketChannel.class;
            groupType = KQueueEventLoopGroup.class;
        } else if (Epoll.isAvailable()) {
            channelType = EpollDomainSocketChannel.class;
            groupType = EpollEventLoopGroup.class;
        } else {
            throw new IllegalArgumentException("Unix domain sockets not supported: missing native libraries");
        }
        int maxThreads = config.getSetting(SystemSettings.PROTOCOL_IO_THREADS);
        ServerConnectionShared.Ref sharedRef = ServerConnectionShared.acquire(groupType, maxThreads);
        final Writer protocolTraceWriter = this.createProtocolTracer(config);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(sharedRef.get().getEventLoopGroup())).channel(channelType)).handler((ChannelHandler)new ChannelInitializer<DomainSocketChannel>(){

            protected void initChannel(DomainSocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxMessageSize, 1, 4, -4, 0), new MessageDispatchHandler(clientEncoding, protocolTraceWriter)});
            }
        });
        this.configureChannelOptions(config, bootstrap);
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)address);
        return new CreatedChannel(sharedRef, channelFuture);
    }

    private void configureChannelOptions(Configuration config, Bootstrap bootstrap) {
        boolean usePooledAllocator;
        Integer sendBufferSize;
        Integer receiveBufferSize = config.getSetting(SystemSettings.PROTOCOL_SOCKET_RECV_BUFFER_SIZE);
        if (receiveBufferSize != null) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)receiveBufferSize);
        }
        if ((sendBufferSize = config.getSetting(SystemSettings.PROTOCOL_SOCKET_SEND_BUFFER_SIZE)) != null) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)sendBufferSize);
        }
        bootstrap.option(ChannelOption.ALLOCATOR, (usePooledAllocator = config.getSetting(SystemSettings.PROTOCOL_BUFFER_POOLING).booleanValue()) ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT);
    }

    private Writer createProtocolTracer(Configuration config) {
        if (config.getSetting(SystemSettings.PROTOCOL_TRACE).booleanValue()) {
            OutputStream out = System.out;
            String filePath = config.getSetting(SystemSettings.PROTOCOL_TRACE_FILE);
            if (filePath != null) {
                try {
                    out = new FileOutputStream(filePath, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return new BufferedWriter(new OutputStreamWriter(out));
        }
        return null;
    }

    private static ServerConnection startup(final Configuration config, Channel channel, final Map<String, String> startupParameterStatuses, ServerConnectionShared.Ref sharedRef) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("application_name", config.getSetting(SystemSettings.APPLICATION_NAME));
        params.put("client_encoding", config.getSetting(SystemSettings.PROTOCOL_ENCODING));
        params.put("database", config.getSetting(SystemSettings.DATABASE_NAME));
        params.put("user", config.getSetting(SystemSettings.CREDENTIALS_USERNAME));
        Version protocolVersion = config.getSetting(SystemSettings.PROTOCOL_VERSION);
        final AtomicReference startupProtocolVersion = new AtomicReference();
        final AtomicReference startupKeyData = new AtomicReference();
        final AtomicReference startupError = new AtomicReference();
        final CountDownLatch startupCompleted = new CountDownLatch(1);
        StartupRequest startupRequest = new StartupRequest(protocolVersion, params, new StartupRequest.CompletionHandler(){

            @Override
            public String authenticateClear() {
                return config.getSetting(SystemSettings.CREDENTIALS_PASSWORD);
            }

            @Override
            public String authenticateMD5(byte[] salt) {
                String username = config.getSetting(SystemSettings.CREDENTIALS_USERNAME);
                String password = config.getSetting(SystemSettings.CREDENTIALS_PASSWORD);
                return MD5Authentication.encode(password, username, salt);
            }

            @Override
            public void authenticateKerberos() {
                throw new IllegalStateException("Unsupported Authentication Method");
            }

            @Override
            public byte authenticateSCM() {
                throw new IllegalStateException("Unsupported Authentication Method");
            }

            @Override
            public ByteBuf authenticateGSS(ByteBuf data) {
                throw new IllegalStateException("Unsupported Authentication Method");
            }

            @Override
            public ByteBuf authenticateSSPI(ByteBuf data) {
                throw new IllegalStateException("Unsupported Authentication Method");
            }

            @Override
            public ByteBuf authenticateContinue(ByteBuf data) {
                throw new IllegalStateException("Unsupported Authentication Method");
            }

            @Override
            public void handleNegotiate(Version maxProtocolVersion, List<String> unrecognizedParameters) {
                startupProtocolVersion.set(maxProtocolVersion);
            }

            @Override
            public void handleComplete(int processId, int secretKey, Map<String, String> parameterStatuses, List<Notice> notices) {
                startupParameterStatuses.putAll(parameterStatuses);
                startupKeyData.set(new ServerConnection.KeyData(processId, secretKey));
                startupCompleted.countDown();
            }

            @Override
            public void handleError(Throwable error, List<Notice> notices) {
                startupError.set(error);
                startupCompleted.countDown();
            }
        });
        channel.writeAndFlush((Object)startupRequest).syncUninterruptibly();
        if (!Await.awaitUninterruptibly(60L, TimeUnit.SECONDS, startupCompleted::await)) {
            throw new IOException("Timeout starting connection");
        }
        if (startupError.get() != null) {
            Throwable error = (Throwable)startupError.get();
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RuntimeException(error);
        }
        ServerInfo serverInfo = new ServerInfo(Version.parse(startupParameterStatuses.remove("server_version")), startupParameterStatuses.remove("server_encoding"), Nulls.firstNonNull(startupParameterStatuses.remove("integer_datetimes"), "on").equalsIgnoreCase("on"));
        protocolVersion = startupProtocolVersion.get() != null ? (Version)startupProtocolVersion.get() : protocolVersion;
        return new ServerConnection(config, channel, serverInfo, protocolVersion, (ServerConnection.KeyData)startupKeyData.get(), sharedRef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHostname(String hostname, SSLSession session) throws SSLPeerUnverifiedException {
        LdapName DN;
        X509Certificate[] peerCerts = (X509Certificate[])session.getPeerCertificates();
        if (peerCerts == null || peerCerts.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
        X509Certificate serverCert = peerCerts[0];
        try {
            DN = new LdapName(serverCert.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException e) {
            throw new SSLPeerUnverifiedException("Invalid name in certificate");
        }
        String CN = null;
        for (Rdn rdn : DN.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            CN = (String)rdn.getValue();
            break;
        }
        if (CN == null) {
            throw new SSLPeerUnverifiedException("Common name not found");
        }
        if (CN.startsWith("*")) {
            if (!hostname.endsWith(CN.substring(1))) throw new SSLPeerUnverifiedException("The hostname " + hostname + " could not be verified");
            if (hostname.substring(0, hostname.length() - CN.length() + 1).contains(".")) return;
            throw new SSLPeerUnverifiedException("The hostname " + hostname + " could not be verified");
        }
        if (CN.equals(hostname)) return;
        throw new SSLPeerUnverifiedException("The hostname " + hostname + " could not be verified");
    }

    private static IOException translateConnectionException(Exception e) {
        IOException io = e instanceof ClosedChannelException ? new IOException("Channel Closed", e) : (e instanceof IOException ? (IOException)e : (e.getCause() == null ? new IOException(e) : (e.getCause() instanceof IOException ? (IOException)e.getCause() : new IOException(e.getCause()))));
        while (io instanceof SSLHandshakeException) {
            if (io.getCause() instanceof IOException) {
                io = (IOException)io.getCause();
                continue;
            }
            if (io.getCause() != null) {
                io = new SSLException(io.getCause().getMessage(), io.getCause());
                continue;
            }
            io = new SSLException(io.getMessage(), io);
        }
        if (io instanceof SSLException && !io.getMessage().startsWith("SSL Error")) {
            io = new SSLException("SSL Error: " + io.getMessage(), io.getCause());
        }
        return io;
    }

    static class DefaultCopyOutHandler
    implements ProtocolHandler.CopyData,
    ProtocolHandler.CopyDone,
    ProtocolHandler.CopyFail {
        OutputStream stream;

        DefaultCopyOutHandler(OutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void copyData(ByteBuf data) throws IOException {
            while (data.isReadable()) {
                data.readBytes(this.stream, data.readableBytes());
            }
        }

        @Override
        public void copyDone() {
        }

        @Override
        public void copyFail(String message) {
        }

        @Override
        public void exception(Throwable cause) {
        }
    }

    static class DefaultHandler
    implements ProtocolHandler.ParameterStatus,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.Notification,
    ProtocolHandler.CopyInResponse,
    ProtocolHandler.CopyOutResponse,
    ProtocolHandler.CommandError {
        private static final Logger logger = Logger.getLogger(ServerConnection.class.getName());
        private WeakReference<ServerConnection.Listener> listener;

        DefaultHandler(ServerConnection.Listener listener) {
            this.listener = new WeakReference<ServerConnection.Listener>(listener);
        }

        private ServerConnection.Listener getListener() {
            return (ServerConnection.Listener)this.listener.get();
        }

        public String toString() {
            return "DEFAULT";
        }

        @Override
        public ProtocolHandler.Action parameterStatus(String name, String value) {
            ServerConnection.Listener listener = this.getListener();
            if (listener != null) {
                listener.parameterStatusChanged(name, value);
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public void notification(int processId, String channelName, String payload) {
            ServerConnection.Listener listener = this.getListener();
            if (listener != null) {
                listener.notificationReceived(processId, channelName, payload);
            }
        }

        @Override
        public InputStream copyIn(CopyFormat format, FieldFormat[] fieldFormats) {
            ServerConnection.Listener listener = this.getListener();
            if (listener == null) {
                return null;
            }
            return listener.openStandardInput();
        }

        @Override
        public ProtocolHandler copyOut(CopyFormat format, FieldFormat[] fieldFormats) {
            ServerConnection.Listener listener = this.getListener();
            if (listener == null) {
                return null;
            }
            return new DefaultCopyOutHandler(listener.openStandardOutput());
        }

        @Override
        public void exception(Channel channel, Throwable cause) {
            ServerConnection.Listener listener;
            if (!channel.isOpen() && (listener = this.getListener()) != null) {
                listener.closed();
            }
        }

        @Override
        public void exception(Throwable cause) {
            if (cause instanceof ClosedChannelException) {
                return;
            }
            logger.log(Level.WARNING, "Unhandled connection exception", cause);
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            return null;
        }

        @Override
        public ProtocolHandler.Action error(Notice notice) {
            logger.warning(notice.getMessage());
            return ProtocolHandler.Action.Resume;
        }
    }

    static class CreatedChannel {
        ServerConnectionShared.Ref sharedRef;
        ChannelFuture channelFuture;

        CreatedChannel(ServerConnectionShared.Ref sharedRef, ChannelFuture channelFuture) {
            this.sharedRef = sharedRef;
            this.channelFuture = channelFuture;
        }
    }
}

