/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.traverser.TraverseQueryBuilder;
import org.simantics.db.common.utils.traverser.TraverseResult;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.export.core.manager.Content;
import org.simantics.layer0.Layer0;

public class ExportQueries {
    public static boolean USE_INDEXER = true;

    public static Read<List<String>> toUris(final Collection<Resource> resources) {
        return new UniqueRead<List<String>>(){

            public List<String> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<String> result = new ArrayList<String>();
                for (Resource r : resources) {
                    result.add(graph.getURI(r));
                }
                return result;
            }
        };
    }

    public static Read<List<Resource>> toResources(final Collection<String> uris) {
        return new UniqueRead<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>();
                for (String uri : uris) {
                    result.add(graph.getResource(uri));
                }
                return result;
            }
        };
    }

    public static Read<Resource> toResource(final String uri) {
        return new UniqueRead<Resource>(){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                return graph.getResource(uri);
            }
        };
    }

    public static Read<List<Resource>> toResources2(final Collection<Content> contents) {
        return new UniqueRead<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>();
                for (Content content : contents) {
                    result.add(graph.getResource(content.url));
                }
                return result;
            }
        };
    }

    public static Read<Map<String, String>> labels(final Collection<String> uris) {
        return new UniqueRead<Map<String, String>>(){

            public Map<String, String> perform(ReadGraph graph) throws DatabaseException {
                HashMap<String, String> result = new HashMap<String, String>();
                NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
                for (String uri : uris) {
                    int c;
                    String label = null;
                    try {
                        Resource r = graph.getResource(uri);
                        label = NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)mode);
                    }
                    catch (AssumptionException assumptionException) {
                    }
                    catch (ValidationException validationException) {
                    }
                    catch (ServiceException serviceException) {}
                    if (label == null && (c = uri.lastIndexOf(47)) >= 0) {
                        label = uri.substring(c + 1);
                    }
                    if (label == null || label.isEmpty()) {
                        label = uri;
                    }
                    result.put(uri, label);
                }
                return result;
            }
        };
    }

    public static Read<String> label(final String uri) {
        return new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                int c;
                String label = null;
                try {
                    Resource r = graph.getResource(uri);
                    label = NameLabelUtil.modalName((ReadGraph)graph, (Resource)r);
                }
                catch (AssumptionException assumptionException) {
                }
                catch (ValidationException validationException) {
                }
                catch (ServiceException serviceException) {}
                if (label == null && (c = uri.lastIndexOf(47)) >= 0) {
                    label = uri.substring(c + 1);
                }
                if (label == null || label.isEmpty()) {
                    label = uri;
                }
                return label;
            }
        };
    }

    public static Read<String> label(final Resource r) {
        return new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                try {
                    return NameLabelUtil.modalName((ReadGraph)graph, (Resource)r);
                }
                catch (AssumptionException assumptionException) {
                }
                catch (ValidationException validationException) {
                }
                catch (ServiceException serviceException) {}
                return null;
            }
        };
    }

    public static Read<List<Resource>> toModels(final Collection<String> contentUris) {
        return new UniqueRead<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>();
                for (String uri : contentUris) {
                    Resource r = graph.getResource(uri);
                    Resource possibleModel = (Resource)graph.syncRequest((Read)new PossibleModel(r));
                    if (result.contains(possibleModel)) continue;
                    result.add(possibleModel);
                }
                return result;
            }
        };
    }

    public static Read<String> toModelUri(final String contentUri) {
        return new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource r = graph.getResource(contentUri);
                Resource possibleModel = (Resource)graph.syncRequest((Read)new PossibleModel(r));
                return possibleModel == null ? null : graph.getURI(possibleModel);
            }
        };
    }

    public static ParametrizedRead<Collection<String>, Collection<String>> parametrizedInstancesOf(final String typeUri) {
        return new ParametrizedRead<Collection<String>, Collection<String>>(){

            public Read<Collection<String>> get(Collection<String> parameter) {
                return ExportQueries.instancesOf(parameter, typeUri);
            }
        };
    }

    public static Read<Collection<String>> instancesOf(final Collection<String> startingLocations, final String typeUri) {
        return new UniqueRead<Collection<String>>(){

            public List<String> perform(ReadGraph graph) throws DatabaseException {
                if (USE_INDEXER) {
                    ArrayList<String> result = new ArrayList<String>();
                    try {
                        Resource type = graph.getResource(typeUri);
                        Instances instances = (Instances)graph.adapt(type, Instances.class);
                        for (String slUri : startingLocations) {
                            Resource sl = graph.getResource(slUri);
                            Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(sl));
                            if (model == null) {
                                model = sl;
                            }
                            for (Resource r : instances.find(graph, model)) {
                                String uri = graph.getPossibleURI(r);
                                if (uri == null || !uri.startsWith(slUri) || uri.length() <= slUri.length() || uri.charAt(slUri.length()) != '/') continue;
                                result.add(uri);
                            }
                        }
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                    return result;
                }
                try {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource type = graph.getResource(typeUri);
                    TraverseQueryBuilder builder = new TraverseQueryBuilder();
                    builder.setStartResources((Collection)graph.syncRequest(ExportQueries.toResources(startingLocations)));
                    builder.followRelation(L0.ConsistsOf);
                    builder.followInstanceOf(L0.Library);
                    try {
                        builder.followInstanceOf(graph.getResource("http://www.apros.fi/Apros-6.1/Folder"));
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                    builder.followAndReturnInstanceOf(type);
                    TraverseResult traverseResult = (TraverseResult)graph.syncRequest((Read)builder.build());
                    return (List)graph.syncRequest(ExportQueries.toUris(traverseResult.result));
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    return Collections.emptyList();
                }
            }
        };
    }

    public static Read<List<Resource>> instancesOf(final Collection<Resource> startingLocations, final Resource type) {
        return new UniqueRead<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                Instances instances = (Instances)graph.adapt(type, Instances.class);
                ArrayList<Resource> result = new ArrayList<Resource>();
                for (Resource sl : startingLocations) {
                    result.addAll(instances.find(graph, sl));
                }
                return result;
            }
        };
    }
}

