/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.forms.DataboardForm;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.impl.DirPublisher;
import org.simantics.export.core.impl.PublisherUtil;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.intf.PublisherClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class FilePublisher
implements PublisherClass {
    public static LabelReference P_ALLOW_OVERWRITE = new LabelReference("Overwrite file(s)");

    @Override
    public void publish(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions, IProgressMonitor monitor) throws ExportException {
        Boolean canOverwrite = ExporterUtils.getBoolean(locationOptions, (ChildReference)P_ALLOW_OVERWRITE);
        for (Content content : contents) {
            if (content.tmpFile == null) {
                throw new ExportException("Internal error, tmpFile was null for " + content.label + content.formatExt);
            }
            String filePath = ExporterUtils.getString(locationOptions, (ChildReference)new LabelReference(content.filename));
            File file = new File(filePath = PublisherUtil.ensureEndsWith(true, content.formatExt, filePath));
            if (file.exists()) {
                if (canOverwrite.booleanValue()) {
                    file.delete();
                } else {
                    throw new ExportException("Would not overwrite " + file.getAbsolutePath());
                }
            }
            content.tmpFile.renameTo(file);
        }
    }

    @Override
    public List<String> validate(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions) throws ExportException {
        ArrayList<String> result = new ArrayList<String>();
        Boolean canOverwrite = ExporterUtils.getBoolean(locationOptions, (ChildReference)P_ALLOW_OVERWRITE);
        if (canOverwrite == null) {
            result.add("CanOverwrite option missing?");
            return result;
        }
        ArrayList<String> missingPaths = new ArrayList<String>();
        for (Content content : contents) {
            String filePath = ExporterUtils.getString(locationOptions, (ChildReference)new LabelReference(content.filename));
            if (filePath == null || filePath.isEmpty()) {
                missingPaths.add(content.filename);
                continue;
            }
            filePath = PublisherUtil.ensureEndsWith(true, content.formatExt, filePath);
            File file = new File(filePath);
            if (canOverwrite.booleanValue() || !file.exists()) continue;
            result.add(String.valueOf(file.getAbsolutePath()) + " already exists.");
        }
        if (!missingPaths.isEmpty()) {
            result.add(0, "Path for " + CollectionUtils.toString(missingPaths, (String)", ") + " is required.");
        }
        return result;
    }

    @Override
    public RecordType locationOptions(ExportContext ctx, List<Content> contents) throws ExportException {
        RecordType rt = new RecordType();
        for (Content content : contents) {
            Format format = ctx.eep.getFormat(content.formatId);
            rt.addComponent(content.filename, (Datatype)DataboardForm.fileSaveDialog((String[])new String[]{format.label(), "*" + format.fileext()}));
        }
        rt.addComponent(FilePublisher.P_ALLOW_OVERWRITE.label, (Datatype)Datatypes.BOOLEAN);
        return rt;
    }

    @Override
    public Variant createLocation(ExportContext ctx, Variant locationOptions) throws ExportException {
        for (File file : this.readLocations(locationOptions).values()) {
            File parentFile = file.getParentFile();
            if (parentFile == null) continue;
            if (parentFile.exists() && !parentFile.isDirectory()) {
                throw new ExportException(parentFile + " is not directory.");
            }
            if (parentFile.exists() || parentFile.mkdirs()) continue;
            throw new ExportException("Failed to create " + parentFile);
        }
        return locationOptions;
    }

    @Override
    public boolean locationExists(ExportContext ctx, Variant locationOptions) throws ExportException {
        boolean exists = true;
        for (File file : this.readLocations(locationOptions).values()) {
            File parentFile = file.getParentFile();
            if (parentFile == null) continue;
            exists &= parentFile.exists() && parentFile.isDirectory();
        }
        return exists;
    }

    @Override
    public void fillDefaultPrefs(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            ra.setValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN, (Object)true);
            String path = ExporterUtils.getString(options, (ChildReference)new LabelReference("Dir", (ChildReference)DirPublisher.P_EXPORT_LOCATION));
            if (path != null) {
                RecordType rt = ra.type();
                int i = 0;
                while (i < rt.getComponentCount()) {
                    String label = rt.getComponent((int)i).name;
                    if (!label.equals(FilePublisher.P_ALLOW_OVERWRITE.label)) {
                        ra.setFieldValue(i, (Binding)Bindings.STRING, (Object)(String.valueOf(path) + "/" + label));
                    }
                    ++i;
                }
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void savePref(Variant locationOptions, Preferences contentScopeNode, Preferences workspaceScopeNode) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            RecordType rt = (RecordType)locationOptions.type();
            int i = 0;
            while (i < rt.getComponentCount()) {
                if (rt.getComponentType(i) instanceof StringType) {
                    String fieldName = rt.getComponent((int)i).name;
                    String value = (String)ra.getFieldValue(i, (Binding)Bindings.STRING);
                    if (value != null) {
                        workspaceScopeNode.put(fieldName, value);
                        contentScopeNode.put(fieldName, value);
                    }
                }
                ++i;
            }
            Boolean b = (Boolean)ra.getValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN);
            if (b != null) {
                contentScopeNode.putBoolean(P_ALLOW_OVERWRITE.tail().toString(), b.booleanValue());
                workspaceScopeNode.putBoolean(P_ALLOW_OVERWRITE.tail().toString(), b.booleanValue());
            }
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void loadPref(Variant locationOptions, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            for (Map.Entry<String, File> entry : this.readLocations(locationOptions).entrySet()) {
                String key = entry.getKey();
                String value = ExporterUtils.getPrefString(contentScopePrefs, workspaceScopePrefs, key);
                if (value == null) continue;
                LabelReference ref = new LabelReference(key);
                ra.setValue((ChildReference)ref, (Binding)Bindings.STRING, (Object)value);
            }
            String key = P_ALLOW_OVERWRITE.tail().toString();
            Boolean b = ExporterUtils.getPrefBoolean(contentScopePrefs, workspaceScopePrefs, key);
            if (b != null) {
                ra.setValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN, (Object)b);
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    Map<String, File> readLocations(Variant location) throws ExportException {
        HashMap<String, File> result = new HashMap<String, File>();
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)location);
            RecordType rt = (RecordType)location.type();
            int i = 0;
            while (i < rt.getComponentCount()) {
                Datatype ct = rt.getComponent((int)i).type;
                if (ct instanceof StringType) {
                    String fieldName = rt.getComponent((int)i).name;
                    String value = (String)ra.getFieldValue(i, (Binding)Bindings.STRING);
                    if (!fieldName.equals(FilePublisher.P_ALLOW_OVERWRITE.label)) {
                        File file = new File(value);
                        result.put(fieldName, file);
                    }
                }
                ++i;
            }
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        return result;
    }
}

