/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.layout;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import org.simantics.debug.graphical.layout.LayoutAlgorithm;
import org.simantics.debug.graphical.model.Edge;
import org.simantics.debug.graphical.model.Node;

public class LayoutGraph {
    static final double G = 0.001;
    static final double K = 0.001;
    static final double Q = 10000.0;

    private static void computeForces(Node[] nodes, Edge[] edges) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = objectArray[n2];
            node.forceX = 0.0;
            node.forceY = 0.0;
            ++n2;
        }
        objectArray = edges;
        n = edges.length;
        n2 = 0;
        while (n2 < n) {
            Object edge = objectArray[n2];
            Node a = ((Edge)edge).getA();
            Node b = ((Edge)edge).getB();
            double ax = a.getX();
            double ay = a.getY();
            double bx = b.getX();
            double by = b.getY();
            double fx = 0.001 * (bx - ax);
            double fy = 0.001 * (by - ay);
            a.forceX += fx;
            a.forceY += fy;
            b.forceX -= fx;
            b.forceY -= fy;
            ++n2;
        }
        int i = 0;
        while (i < nodes.length) {
            Node a = nodes[i];
            a.forceX -= a.getX() * 0.001;
            a.forceY -= a.getY() * 0.001;
            int j = i + 1;
            while (j < nodes.length) {
                double by;
                double dy;
                Node b = nodes[j];
                double ax = a.getX();
                double ay = a.getY();
                double bx = b.getX();
                double dx = bx - ax;
                double l2 = dx * dx + (dy = (by = b.getY()) - ay) * dy;
                if (l2 > 0.1) {
                    double l = Math.sqrt(l2);
                    double l3 = l * l2;
                    double fx = 10000.0 * dx / l3;
                    double fy = 10000.0 * dy / l3;
                    a.forceX -= fx;
                    a.forceY -= fy;
                    b.forceX += fx;
                    b.forceY += fy;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void layout(Node[] nodes, Edge[] edges) {
        TObjectIntHashMap nodeIds = new TObjectIntHashMap();
        int i = 0;
        while (i < nodes.length) {
            nodeIds.put((Object)nodes[i], i);
            ++i;
        }
        int[][] neighbors = new int[nodes.length][];
        TIntArrayList[] neighborLists = new TIntArrayList[nodes.length];
        int i2 = 0;
        while (i2 < neighborLists.length) {
            neighborLists[i2] = new TIntArrayList();
            ++i2;
        }
        Edge[] edgeArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge = edgeArray[n2];
            Node a = edge.getA();
            Node b = edge.getB();
            int aId = nodeIds.get((Object)a);
            int bId = nodeIds.get((Object)b);
            neighborLists[aId].add(bId);
            neighborLists[bId].add(aId);
            ++n2;
        }
        i = 0;
        while (i < neighborLists.length) {
            TIntArrayList l = neighborLists[i];
            LayoutGraph.removeDuplicates(l);
            neighbors[i] = l.toArray();
            ++i;
        }
        LayoutAlgorithm algo = new LayoutAlgorithm(neighbors);
        double[] posX = algo.getPosX();
        double[] posY = algo.getPosY();
        int i3 = 0;
        while (i3 < nodes.length) {
            posX[i3] = nodes[i3].getX();
            posY[i3] = nodes[i3].getY();
            ++i3;
        }
        algo.optimize();
        i3 = 0;
        while (i3 < nodes.length) {
            nodes[i3].setPos(posX[i3], posY[i3]);
            ++i3;
        }
    }

    private static void removeDuplicates(TIntArrayList l) {
        l.sort();
        int length = l.size();
        int tgt = 0;
        int tgtValue = l.get(tgt);
        int src = 1;
        while (src < length) {
            int srcValue = l.get(src);
            if (srcValue != tgtValue) {
                tgtValue = srcValue;
                l.set(++tgt, tgtValue);
            }
            ++src;
        }
        --length;
        while (length > tgt) {
            l.removeAt(length);
            --length;
        }
    }

    public static void layoutOld(Node[] nodes, Edge[] edges) {
        TObjectIntHashMap nodeIds = new TObjectIntHashMap();
        int i = 0;
        while (i < nodes.length) {
            nodeIds.put((Object)nodes[i], i);
            ++i;
        }
        ArrayList[] neighbors = new ArrayList[nodes.length];
        int i2 = 0;
        while (i2 < neighbors.length) {
            neighbors[i2] = new ArrayList();
            ++i2;
        }
        Edge[] edgeArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge = edgeArray[n2];
            Node a = edge.getA();
            Node b = edge.getB();
            neighbors[nodeIds.get((Object)a)].add(b);
            neighbors[nodeIds.get((Object)b)].add(a);
            ++n2;
        }
        int iter = 0;
        while (iter < 1) {
            int i3 = 0;
            while (i3 < nodes.length) {
                double dy;
                double dx;
                Node node = nodes[i3];
                double x = node.getX();
                double y = node.getY();
                double forceX = -0.001 * x;
                double forceY = -0.001 * y;
                double idS = -0.001;
                ArrayList ns = neighbors[i3];
                idS -= 0.001 * (double)ns.size();
                for (Node n3 : ns) {
                    forceX -= 0.001 * (x - n3.getX());
                    forceY -= 0.001 * (y - n3.getY());
                }
                double xx = 0.0;
                double xy = 0.0;
                double yy = 0.0;
                int j = 0;
                while (j < nodes.length) {
                    Node n4;
                    double l2;
                    if (i3 != j && (l2 = (dx = x - (n4 = nodes[j]).getX()) * dx + (dy = y - n4.getY()) * dy) > 0.01) {
                        double l = Math.sqrt(l2);
                        double l3 = l * l2;
                        idS += 10000.0 / l3;
                        double l5 = l3 * l2;
                        xx -= 10000.0 * dx * dx / l5;
                        xy -= 10000.0 * dx * dy / l5;
                        yy -= 10000.0 * dy * dy / l5;
                        forceX += 10000.0 * dx / l3;
                        forceY += 10000.0 * dy / l3;
                    }
                    ++j;
                }
                System.out.println("force" + i3 + " = (" + forceX + ", " + forceY + ")");
                double det = (xx += idS) * (yy += idS) - xy * xy;
                System.out.println("mx" + i3 + " = (" + xx + "," + xy + "," + yy + ") " + det);
                if (Math.abs(det) > 1.0E-6) {
                    dx = (yy * forceX - xy * forceY) / det;
                    dy = (xx * forceY - xy * forceX) / det;
                    node.setPos(x - dx * 0.5, y - dy * 0.5);
                }
                ++i3;
            }
            ++iter;
        }
    }
}

