/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.service.SerialisationSupport;

public class VariableBean
extends Bean {
    public final long context;
    public final String rvi;
    public final transient Variable variable;

    public VariableBean(ReadGraph graph, Variable variable) throws DatabaseException {
        Variable context = Variables.getPossibleContext(graph, variable);
        if (context != null) {
            RVI rvi = variable.getRVI(graph);
            Resource contextResource = context.getRepresents(graph);
            this.context = contextResource.getResourceId();
            this.rvi = rvi.toString();
        } else {
            this.context = 0L;
            this.rvi = variable.getURI(graph);
        }
        this.variable = variable;
    }

    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        if (this.context != 0L) {
            Resource contextResource = ((SerialisationSupport)graph.getService(SerialisationSupport.class)).getResource(this.context);
            Variable context = Variables.getVariable(graph, contextResource);
            RVI rvi = RVI.fromResourceFormat((RequestProcessor)graph, this.rvi);
            return rvi.resolve(graph, context);
        }
        return Variables.getVariable(graph, this.rvi);
    }

    public Variable getVariable() {
        return this.variable;
    }
}

