/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.TGValueModifier;

public class ComposedTGValueModifier
implements TGValueModifier {
    final TGValueModifier[] modifiers;

    public ComposedTGValueModifier(TGValueModifier[] modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public boolean mayNeedModification(Datatype type) throws DatabaseException {
        TGValueModifier[] tGValueModifierArray = this.modifiers;
        int n = this.modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            TGValueModifier mod = tGValueModifierArray[n2];
            if (mod.mayNeedModification(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object modify(DomainProcessorState state, Binding binding, Object value) throws DatabaseException {
        Datatype type = binding.type();
        TGValueModifier[] tGValueModifierArray = this.modifiers;
        int n = this.modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            TGValueModifier mod = tGValueModifierArray[n2];
            if (mod.mayNeedModification(type)) {
                value = mod.modify(state, binding, value);
            }
            ++n2;
        }
        return value;
    }
}

