/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.hints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.simantics.utils.datastructures.hints.AbstractHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintStack;
import org.simantics.utils.datastructures.prioritystack.IPriorityStack;
import org.simantics.utils.datastructures.prioritystack.IPriorityStackListener;
import org.simantics.utils.datastructures.prioritystack.PriorityStack;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class HintStack
extends AbstractHintObservable
implements IHintStack {
    PriorityStack<IHintContext> stack = new PriorityStack<IHintContext>(IHintContext.class);
    IPriorityStackListener<IHintContext> stackListener = new IPriorityStackListener<IHintContext>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void itemAdded(IPriorityStack<IHintContext> sender, IHintContext item) {
            item.addHintListener(HintStack.this.ctxListener);
            ArrayList<Executable> executables = new ArrayList<Executable>();
            PriorityStack<IHintContext> priorityStack = HintStack.this.stack;
            synchronized (priorityStack) {
                void var10_13;
                void var10_11;
                if (!HintStack.this.hasListeners()) {
                    return;
                }
                Map<IHintContext.Key, Object> hints = item.getHints();
                if (hints.size() == 0) {
                    return;
                }
                HashSet<IHintContext.Key> keys = new HashSet<IHintContext.Key>(hints.keySet());
                HashMap<IHintContext.Key, Object> oldValues = new HashMap<IHintContext.Key, Object>();
                IHintContext[] list = HintStack.this.stack.toArray();
                int index = HintStack.this.stack.indexOf(item);
                int n = index + 1;
                while (var10_11 < list.length) {
                    keys.removeAll(list[var10_11].getHints().keySet());
                    ++var10_11;
                }
                int n2 = index - 1;
                while (var10_13 >= 0) {
                    Map<IHintContext.Key, Object> lowerLevelHints = list[var10_13].getHints();
                    lowerLevelHints.keySet().retainAll(keys);
                    keys.removeAll(lowerLevelHints.keySet());
                    oldValues.putAll(lowerLevelHints);
                    --var10_13;
                }
                for (IHintContext.Key key : keys) {
                    Object newValue = hints.get(key);
                    HintStack.this.addFireKeyChangedExecutables(executables, HintStack.this, key, null, newValue);
                }
                for (Map.Entry entry : oldValues.entrySet()) {
                    IHintContext.Key key = (IHintContext.Key)entry.getKey();
                    Object oldValue = entry.getValue();
                    Object newValue = hints.get(key);
                    HintStack.this.addFireKeyChangedExecutables(executables, HintStack.this, key, oldValue, newValue);
                }
            }
            ThreadUtils.multiSyncExec(executables);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void itemRemoved(IPriorityStack<IHintContext> sender, IHintContext item) {
            item.removeHintListener(HintStack.this.ctxListener);
            ArrayList<Executable> executables = new ArrayList<Executable>();
            PriorityStack<IHintContext> priorityStack = HintStack.this.stack;
            synchronized (priorityStack) {
                void var10_13;
                void var10_11;
                if (!HintStack.this.hasListeners()) {
                    return;
                }
                Map<IHintContext.Key, Object> hints = item.getHints();
                if (hints.size() == 0) {
                    return;
                }
                HashSet<IHintContext.Key> keys = new HashSet<IHintContext.Key>(hints.keySet());
                HashMap<IHintContext.Key, Object> overriddenValues = new HashMap<IHintContext.Key, Object>();
                IHintContext[] list = HintStack.this.stack.toArray();
                int index = HintStack.this.stack.indexOf(item);
                int n = index + 1;
                while (var10_11 < list.length) {
                    keys.removeAll(list[var10_11].getHints().keySet());
                    ++var10_11;
                }
                int n2 = index - 1;
                while (var10_13 >= 0) {
                    Map<IHintContext.Key, Object> lowerLevelHints = list[var10_13].getHints();
                    lowerLevelHints.keySet().retainAll(keys);
                    keys.removeAll(lowerLevelHints.keySet());
                    overriddenValues.putAll(lowerLevelHints);
                    --var10_13;
                }
                for (IHintContext.Key key : keys) {
                    Object oldValue = hints.get(key);
                    HintStack.this.addFireKeyRemovedExecutables(executables, HintStack.this, key, oldValue);
                }
                for (Map.Entry entry : overriddenValues.entrySet()) {
                    IHintContext.Key key = (IHintContext.Key)entry.getKey();
                    Object newValue = entry.getValue();
                    Object oldValue = hints.get(key);
                    HintStack.this.addFireKeyChangedExecutables(executables, HintStack.this, key, oldValue, newValue);
                }
            }
            ThreadUtils.multiSyncExec(executables);
        }
    };
    IHintListener ctxListener = new IHintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            Runnable notifications;
            PriorityStack<IHintContext> priorityStack = HintStack.this.stack;
            synchronized (priorityStack) {
                IHintContext[] list = HintStack.this.stack.toArray();
                int index = HintStack.this.stack.indexOf((IHintContext)sender);
                if (index < 0) {
                    return;
                }
                int i = index + 1;
                while (i < list.length) {
                    if (list[i].getHint(key) != null) {
                        return;
                    }
                    ++i;
                }
                if (oldValue == null) {
                    i = index - 1;
                    while (i >= 0) {
                        oldValue = list[i].getHint(key);
                        if (oldValue != null) break;
                        --i;
                    }
                }
                notifications = HintStack.this.createFireKeyChangedRunnable(HintStack.this, key, oldValue, newValue);
            }
            notifications.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
            Runnable notification;
            PriorityStack<IHintContext> priorityStack = HintStack.this.stack;
            synchronized (priorityStack) {
                IHintContext[] list = HintStack.this.stack.toArray();
                int index = HintStack.this.stack.indexOf((IHintContext)sender);
                if (index < 0) {
                    return;
                }
                int i = index + 1;
                while (i < list.length) {
                    if (list[i].getHint(key) != null) {
                        return;
                    }
                    ++i;
                }
                Object newValue = null;
                int i2 = index - 1;
                while (i2 >= 0) {
                    newValue = list[i2].getHint(key);
                    if (newValue != null) break;
                    --i2;
                }
                notification = newValue != null ? HintStack.this.createFireKeyChangedRunnable(HintStack.this, key, oldValue, newValue) : HintStack.this.createFireKeyRemovedRunnable(HintStack.this, key, oldValue);
            }
            notification.run();
        }
    };

    public HintStack() {
        this.stack.addStackListener(this.stackListener);
    }

    @Override
    public void addHintContext(IHintContext hints, int priority) {
        this.stack.add(hints, priority);
    }

    @Override
    public <E> E getHint(IHintContext.Key key) {
        IHintContext[] list = this.stack.toArray();
        int i = list.length - 1;
        while (i >= 0) {
            IHintContext ctx = list[i];
            Object value = ctx.getHint(key);
            if (value != null) {
                return value;
            }
            --i;
        }
        return null;
    }

    @Override
    public boolean containsHint(IHintContext.Key key) {
        IHintContext[] list = this.stack.toArray();
        int i = list.length - 1;
        while (i >= 0) {
            IHintContext ctx = list[i];
            if (ctx.containsHint(key)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public boolean removeHintContext(IHintContext hints) {
        return this.stack.remove(hints);
    }

    @Override
    public synchronized Map<IHintContext.Key, Object> getHints() {
        HashMap<IHintContext.Key, Object> result = new HashMap<IHintContext.Key, Object>();
        IHintContext[] iHintContextArray = this.stack.toArray();
        int n = iHintContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHintContext ctx = iHintContextArray[n2];
            result.putAll(ctx.getHints());
            ++n2;
        }
        return result;
    }

    @Override
    public synchronized Map<IHintContext.Key, Object> getHintsUnsafe() {
        return this.getHints();
    }

    @Override
    public <E extends IHintContext.Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        HashMap<E, Object> result = new HashMap<E, Object>();
        IHintContext[] iHintContextArray = this.stack.toArray();
        int n = iHintContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHintContext ctx = iHintContextArray[n2];
            result.putAll(ctx.getHintsOfClass(clazz));
            ++n2;
        }
        return result;
    }

    @Override
    public IHintContext createStackRead(final IHintContext ctx) {
        return new IHintContext(){

            @Override
            public void clearWithoutNotification() {
                ctx.clearWithoutNotification();
            }

            @Override
            public <E> E removeHint(IHintContext.Key key) {
                return ctx.removeHint(key);
            }

            @Override
            public void setHint(IHintContext.Key key, Object value) {
                ctx.setHint(key, value);
            }

            @Override
            public void addHintListener(IHintListener listener) {
                HintStack.this.addHintListener(listener);
            }

            @Override
            public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
                HintStack.this.addHintListener(threadAccess, listener);
            }

            @Override
            public void addKeyHintListener(IHintContext.Key key, IHintListener listener) {
                HintStack.this.addKeyHintListener(key, listener);
            }

            @Override
            public void addKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
                HintStack.this.addKeyHintListener(threadAccess, key, listener);
            }

            @Override
            public boolean containsHint(IHintContext.Key key) {
                return HintStack.this.containsHint(key);
            }

            @Override
            public <E> E getHint(IHintContext.Key key) {
                return HintStack.this.getHint(key);
            }

            @Override
            public Map<IHintContext.Key, Object> getHints() {
                return HintStack.this.getHints();
            }

            @Override
            public Map<IHintContext.Key, Object> getHintsUnsafe() {
                return HintStack.this.getHintsUnsafe();
            }

            @Override
            public void removeHintListener(IHintListener listener) {
                HintStack.this.removeHintListener(listener);
            }

            @Override
            public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
                HintStack.this.removeHintListener(threadAccess, listener);
            }

            @Override
            public void removeKeyHintListener(IHintContext.Key key, IHintListener listener) {
                HintStack.this.removeKeyHintListener(key, listener);
            }

            @Override
            public void removeKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
                HintStack.this.removeKeyHintListener(threadAccess, key, listener);
            }

            @Override
            public <E extends IHintContext.Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
                return HintStack.this.getHintsOfClass(clazz);
            }

            @Override
            public void setHints(Map<IHintContext.Key, Object> hints) {
                ctx.setHints(hints);
            }
        };
    }
}

