/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class MapSet<L, R> {
    protected Map<L, Set<R>> sets;

    public boolean add(L key, R value) {
        Set<R> set = this.getOrCreateSet(key);
        return set.add(value);
    }

    protected abstract Set<R> getOrCreateSet(L var1);

    private Set<R> getSet(L key) {
        return this.sets.get(key);
    }

    public Set<R> removeValues(L key) {
        Set<R> set = this.sets.remove(key);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public boolean remove(L key, R value) {
        Set<R> set = this.getSet(key);
        if (set == null) {
            return false;
        }
        boolean result = set.remove(value);
        if (set.isEmpty()) {
            this.sets.remove(key);
        }
        return result;
    }

    public void clear() {
        this.sets.clear();
    }

    public L[] getKeys(L[] list) {
        return this.sets.keySet().toArray(list);
    }

    public Set<L> getKeys() {
        return this.sets.keySet();
    }

    public boolean hasValues(L key) {
        return this.sets.containsKey(key);
    }

    public R[] getValues(L key, R[] list) {
        Set<R> l = this.sets.get(key);
        if (l == null) {
            return null;
        }
        return l.toArray(list);
    }

    public Set<R> getValues(L key) {
        Set<R> l = this.sets.get(key);
        if (l == null) {
            return null;
        }
        return new HashSet<R>(l);
    }

    public Set<R> getValuesUnsafe(L key) {
        return this.sets.get(key);
    }

    public static class Hash<L, R>
    extends MapSet<L, R> {
        public Hash() {
            this.sets = new HashMap();
        }

        @Override
        protected Set<R> getOrCreateSet(L key) {
            HashSet set = (HashSet)this.sets.get(key);
            if (set == null) {
                set = new HashSet();
                this.sets.put(key, set);
            }
            return set;
        }
    }

    public static class Tree<L, R>
    extends MapSet<L, R> {
        public Tree() {
            this.sets = new TreeMap();
        }

        public Tree(Comparator<? super L> comparator) {
            this.sets = new TreeMap(comparator);
        }

        @Override
        protected Set<R> getOrCreateSet(L key) {
            HashSet set = (HashSet)this.sets.get(key);
            if (set == null) {
                set = new HashSet();
                this.sets.put(key, set);
            }
            return set;
        }
    }
}

