/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;

public class NewSymbol {
    public static Resource createSymbol(WriteGraph graph, Resource componentType) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)componentType);
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(componentType));
        Resource symbolDiagramType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolDiagramType);
        if (symbolDiagramType == null) {
            symbolDiagramType = DIA.Composite;
        }
        String symbolName = NameUtils.findFreshName((ReadGraph)graph, (String)"Symbol", (Resource)componentType);
        Resource symbol = new ModelingUtils(graph).createSymbol2(symbolName, symbolDiagramType);
        graph.claim(componentType, MOD.ComponentTypeToSymbol, symbol);
        graph.claim(componentType, L0.ConsistsOf, symbol);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Created new user component symbol " + symbolName + ", resource " + symbol));
        return componentType;
    }
}

