/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.actions;

import gnu.trove.map.hash.THashMap;
import java.awt.Graphics2D;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.actions.IReconnectAction;
import org.simantics.diagram.connection.actions.ReconnectTerminalAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class ReconnectLineAction
implements IReconnectAction {
    RouteGraph rg;
    RouteGraph rgc;
    RouteLine line;

    public ReconnectLineAction(RouteGraph rg, RouteGraph rgc, RouteLine line) {
        this.rg = rg;
        this.rgc = rgc;
        this.line = line;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        RouteLine sLine;
        THashMap map = new THashMap();
        RouteGraph rgc = this.rgc.copy((THashMap<Object, Object>)map);
        if (!rgc.connectLine(sLine = (RouteLine)map.get((Object)this.line), mouseX, mouseY, 1.0) || !rgc.isTree()) {
            map.clear();
            rgc = this.rgc.copy((THashMap<Object, Object>)map);
            sLine = (RouteLine)map.get((Object)this.line);
            RouteTerminal t2 = rgc.addTerminal(mouseX, mouseY, mouseX, mouseY, mouseX, mouseY, 15);
            rgc.link(sLine, t2);
        }
        renderer.render(g, rgc);
    }

    @Override
    public void finish(double x, double y) {
        if (this.rgc.connectLine(this.line, x, y, 1.0) && this.rgc.isTree()) {
            this.rgc.removeExtraConnections();
            this.rg.replaceBy(this.rgc);
        }
    }

    public static IAction create(RouteGraph rg, double x, double y) {
        RouteGraph rgc = rg.copy();
        RouteLineHalf lh = rgc.pickLineHalf(x, y, 1.0);
        if (lh == null) {
            return null;
        }
        RouteLine line = lh.getLine();
        if (line.isTransient()) {
            RouteTerminal terminal = line.getTerminal();
            rgc.disconnect(terminal);
            return new ReconnectTerminalAction(rg, rgc, terminal);
        }
        rgc.makePersistent(line);
        rgc.remove(lh.getLink());
        return new ReconnectLineAction(rg, rgc, line);
    }
}

