/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.compression;

import java.util.Arrays;
import org.simantics.scl.compiler.parser.generator.compression.CompressedTable;
import org.simantics.scl.compiler.parser.generator.compression.GraphColoring;

public class GCCompress {
    public static final int DONT_CARE = 65535;

    private static int[][] compressRows(int[] colors, final int[][] table) {
        final int columns = table[0].length;
        int colorCount = GraphColoring.color(colors, new GraphColoring.ColGraph(){

            @Override
            public int size() {
                return table.length;
            }

            @Override
            public boolean areConnected(int a, int b) {
                int[] aRow = table[a];
                int[] bRow = table[b];
                int i = 0;
                while (i < columns) {
                    int aV = aRow[i];
                    int bV = bRow[i];
                    if (aV != 65535 && bV != 65535 && aV != bV) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        int[][] compr = new int[colorCount][columns];
        int i = 0;
        while (i < compr.length) {
            Arrays.fill(compr[i], 65535);
            ++i;
        }
        i = 0;
        while (i < table.length) {
            int color = colors[i];
            int[] inRow = table[i];
            int[] outRow = compr[color];
            int j = 0;
            while (j < columns) {
                int v = inRow[j];
                if (v != 65535) {
                    outRow[j] = v;
                }
                ++j;
            }
            ++i;
        }
        return compr;
    }

    private static int[][] compressColumns(int[] colors, final int[][] table) {
        final int columns = table[0].length;
        int colorCount = GraphColoring.color(colors, new GraphColoring.ColGraph(){

            @Override
            public int size() {
                return columns;
            }

            @Override
            public boolean areConnected(int a, int b) {
                int i = 0;
                while (i < table.length) {
                    int[] row = table[i];
                    int aV = row[a];
                    int bV = row[b];
                    if (aV != 65535 && bV != 65535 && aV != bV) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        int[][] compr = new int[table.length][colorCount];
        int i = 0;
        while (i < compr.length) {
            Arrays.fill(compr[i], 65535);
            ++i;
        }
        i = 0;
        while (i < table.length) {
            int j = 0;
            while (j < columns) {
                int v = table[i][j];
                if (v != 65535) {
                    int color = colors[j];
                    compr[i][color] = v;
                }
                ++j;
            }
            ++i;
        }
        return compr;
    }

    public static CompressedTable compress(int[][] table) {
        System.out.println("Compress:");
        System.out.println("    Rows: " + table.length);
        System.out.println("    Columns: " + table[0].length);
        int[] rowIndex = new int[table.length];
        int[] columnIndex = new int[table[0].length];
        table = GCCompress.compressRows(rowIndex, table);
        table = GCCompress.compressColumns(columnIndex, table);
        System.out.println("    Compressed rows: " + table.length);
        System.out.println("    Compressed columns: " + table[0].length);
        int columns = table[0].length;
        int[] compressedTable = new int[table.length * columns];
        int i = 0;
        while (i < table.length) {
            System.arraycopy(table[i], 0, compressedTable, i * columns, columns);
            ++i;
        }
        i = 0;
        while (i < rowIndex.length) {
            int n = i++;
            rowIndex[n] = rowIndex[n] * columns;
        }
        return new CompressedTable(rowIndex, columnIndex, compressedTable);
    }
}

