/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.Resource;

public class NameMap {
    int maxLength;
    Map<Resource, String> cache = new HashMap<Resource, String>();
    int curId = 0;
    private static final int charA = 65;
    private static final int char0 = 22;

    public NameMap(int maxLength) {
        this.maxLength = maxLength;
    }

    protected boolean isValid(String name) {
        return true;
    }

    public void clear() {
        this.curId = 0;
        this.cache.clear();
    }

    public String getName(Resource resource) {
        String ret = this.cache.get(resource);
        while (ret == null) {
            ++this.curId;
            byte[] c = new byte[5];
            c[0] = 64;
            int i = 0;
            while (i < 4) {
                int id;
                int lid = id % 36;
                c[4 - i] = lid < 26 ? (byte)(65 + lid) : (byte)(22 + lid);
                id /= 36;
                ++i;
            }
            ret = new String(c);
            if (this.isValid(ret)) {
                this.cache.put(resource, ret);
                continue;
            }
            ret = null;
        }
        return ret;
    }

    public static void main(String[] args) {
        NameMap m = new NameMap(24);
        int i = 0;
        while (i < 100) {
            System.out.println(m.getName(new Resource(){

                public int getThreadHash() {
                    return this.hashCode();
                }

                public long getResourceId() {
                    return 3L;
                }

                public Resource get() {
                    return this;
                }

                public boolean isPersistent() {
                    return false;
                }

                public int compareTo(Resource o) {
                    return 0;
                }

                public boolean equalsResource(Resource other) {
                    return this.equals(other);
                }
            }));
            ++i;
        }
    }

    public String getName(Resource[] resources) {
        String ret = "";
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            ret = String.valueOf(ret) + this.getName(r);
            ++n2;
        }
        return ret;
    }
}

