/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.simantics.browsing.ui.swt.InputValidators;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.VariableStringPropertyTextModifier;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleProperty;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.InputValidator;
import org.simantics.db.layer0.variable.InputValidatorFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.PropertyTabContributorImpl;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class ConfigurationComposite
extends PropertyTabContributorImpl {
    protected FormToolkit toolkit;
    protected LocalResourceManager resourceManager;
    protected Font font;
    protected Font smallFont;
    protected Font smallFont2;
    ScrolledComposite explorersScroll;
    Composite explorers;
    protected ScrollListener listener;

    protected Composite createScroll(Composite body) {
        return this.createScroll(body, 1);
    }

    protected Composite createScroll(Composite body, int minSize) {
        return this.createScroll(body, minSize, 1);
    }

    protected Composite createScroll(Composite body, int minSize, int columnCount) {
        this.listener = new ScrollListener(minSize);
        this.explorersScroll = new ScrolledComposite(body, 2560);
        this.explorersScroll.setBackground(Display.getCurrent().getSystemColor(1));
        this.explorersScroll.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).create());
        this.explorersScroll.setExpandVertical(false);
        this.explorersScroll.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.explorersScroll);
        this.explorers = new Composite((Composite)this.explorersScroll, 0);
        this.explorers.setBackground(Display.getCurrent().getSystemColor(1));
        this.explorers.setSize(10, 300);
        this.explorers.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(columnCount).spacing(0, 0).create());
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.explorers);
        this.explorersScroll.setMinSize(100, 100);
        this.explorersScroll.setContent((Control)this.explorers);
        return this.explorers;
    }

    protected void registerScrollExplorers(Control ... composites) {
        this.listener.composites = composites;
        Control[] controlArray = composites;
        int n = composites.length;
        int n2 = 0;
        while (n2 < n) {
            Control composite = controlArray[n2];
            if (composite instanceof GraphExplorerComposite) {
                ScrollListener listener = this.listener;
                if (listener == null) {
                    listener = this.listener;
                }
                Tree tree = (Tree)((GraphExplorerComposite)composite).getExplorerControl();
                tree.addListener(36, (Listener)listener);
            }
            ++n2;
        }
    }

    protected Label createHeaderLabel(final Composite body, final Composite headerComposite, final ISessionContext context, final WidgetSupport support) {
        final Label header = new Label(headerComposite, support, 0);
        header.getWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                final Display display = Display.getCurrent();
                if (!$assertionsDisabled && display == null) {
                    throw new AssertionError();
                }
                context.getSession().asyncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Object input = support.getInput();
                        if (input != WidgetSupport.NO_INPUT && input != null && input instanceof ISelection) {
                            Variable inputVariable = (Variable)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Variable.class);
                            Variable nameVariable = inputVariable.getPossibleProperty(graph, "HasName");
                            final String initial = (String)nameVariable.getValue(graph, (Binding)Bindings.STRING);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Resource inputResource = inputVariable.getRepresents(graph);
                            if (inputResource == null) {
                                return;
                            }
                            Resource nameResource = graph.getPossibleObject(inputResource, L0.HasName);
                            if (nameResource == null) {
                                return;
                            }
                            Resource validatorResource = (Resource)graph.syncRequest((Read)new PossibleProperty(nameResource, "HasInputValidator"));
                            if (validatorResource == null) {
                                return;
                            }
                            InputValidatorFactory validatorFactory = (InputValidatorFactory)graph.adapt(validatorResource, InputValidatorFactory.class);
                            final InputValidator validator = validatorFactory.create(graph, nameVariable);
                            if (initial != null && validator != null) {
                                if (display.isDisposed()) {
                                    return;
                                }
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).align(0x1000000, 0x1000000).applyTo((Control)header.getWidget());
                                        header.getWidget().setVisible(false);
                                        final Composite editor = new Composite(headerComposite, 0);
                                        editor.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).create());
                                        editor.setBackground(Display.getCurrent().getSystemColor(1));
                                        TrackedText name = new TrackedText(editor, support, 0);
                                        name.setText(initial);
                                        name.setInputValidator(InputValidators.string((InputValidator)validator));
                                        name.setFont(((this).this).ConfigurationComposite.this.font);
                                        name.addModifyListener((TextModifyListener)new VariableStringPropertyTextModifier("HasName"));
                                        name.addModifyListener(new TextModifyListener(){

                                            public void modifyText(TrackedModifyEvent e) {
                                                editor.dispose();
                                                header.getWidget().setVisible(true);
                                                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)header.getWidget());
                                            }
                                        });
                                        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).align(4, 4).applyTo((Control)name.getWidget());
                                        name.getWidget().forceFocus();
                                        name.startEdit(true);
                                        editor.moveAbove(null);
                                        final Label label = new Label(editor, support, 0);
                                        label.setFont(((this).this).ConfigurationComposite.this.smallFont2);
                                        label.setBackground(Display.getCurrent().getSystemColor(1));
                                        label.setForeground(Display.getCurrent().getSystemColor(4));
                                        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).align(4, 4).applyTo((Control)label.getWidget());
                                        name.addValidationListener((Consumer)new Consumer<String>(){

                                            @Override
                                            public void accept(String error) {
                                                if (error != null) {
                                                    label.setText(error);
                                                } else {
                                                    label.setText("");
                                                }
                                            }
                                        });
                                        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).align(4, 4).applyTo((Control)editor);
                                        body.layout(true);
                                        headerComposite.layout(true);
                                        support.update((Widget)name);
                                    }
                                });
                            }
                        }
                    }
                });
            }
        });
        header.setFont(this.font);
        header.setBackground(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)header.getWidget());
        return header;
    }

    protected Label createResourceHeaderLabel(final Composite body, final Composite headerComposite, final ISessionContext context, final WidgetSupport support) {
        final Label header = new Label(headerComposite, support, 0);
        header.getWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                final Display display = Display.getCurrent();
                if (!$assertionsDisabled && display == null) {
                    throw new AssertionError();
                }
                context.getSession().asyncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Object input = support.getInput();
                        if (input != WidgetSupport.NO_INPUT && input != null && input instanceof ISelection) {
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Resource streamClass = (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Resource.class);
                            final String initial = (String)graph.getRelatedValue(streamClass, L0.HasName, (Binding)Bindings.STRING);
                            if (initial != null) {
                                if (display.isDisposed()) {
                                    return;
                                }
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).align(0x1000000, 0x1000000).applyTo((Control)header.getWidget());
                                        header.getWidget().setVisible(false);
                                        final TrackedText name = new TrackedText(headerComposite, support, 0);
                                        name.setText(initial);
                                        name.setFont(((this).this).ConfigurationComposite.this.font);
                                        name.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasName"));
                                        name.addModifyListener(new TextModifyListener(){

                                            public void modifyText(TrackedModifyEvent e) {
                                                name.getWidget().dispose();
                                                header.getWidget().setVisible(true);
                                                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)header.getWidget());
                                                body.layout(true);
                                                headerComposite.layout(true);
                                            }
                                        });
                                        name.getWidget().forceFocus();
                                        name.startEdit(true);
                                        name.getWidget().moveAbove(null);
                                        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).align(4, 4).applyTo((Control)name.getWidget());
                                        body.layout(true);
                                        headerComposite.layout(true);
                                        support.update((Widget)name);
                                    }
                                });
                            }
                        }
                    }
                });
            }
        });
        header.setFont(this.font);
        header.setBackground(Display.getCurrent().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)header.getWidget());
        return header;
    }

    protected Composite createHeaderComposite(Composite body) {
        return this.createHeaderComposite(body, 2);
    }

    protected Composite createHeaderComposite(Composite body, int width) {
        Composite headerComposite = new Composite(body, 0);
        headerComposite.setBackground(body.getDisplay().getSystemColor(2));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)headerComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(2, 2, 2, 2).applyTo(headerComposite);
        Composite headerComposite2 = new Composite(headerComposite, 0);
        headerComposite2.setBackground(body.getDisplay().getSystemColor(1));
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)headerComposite2);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(width).extendedMargins(3, 3, 3, 3).applyTo(headerComposite2);
        return headerComposite2;
    }

    protected void create(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
    }

    @Override
    public final void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)body);
        this.toolkit = new FormToolkit(body.getDisplay());
        body.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ConfigurationComposite.this.toolkit.dispose();
            }
        });
        this.font = (Font)this.resourceManager.get((DeviceResourceDescriptor)FontDescriptor.createFrom((String)"Arial", (int)14, (int)0));
        this.smallFont = (Font)this.resourceManager.get((DeviceResourceDescriptor)FontDescriptor.createFrom((String)"Arial", (int)10, (int)0));
        this.smallFont2 = (Font)this.resourceManager.get((DeviceResourceDescriptor)FontDescriptor.createFrom((String)"Arial", (int)8, (int)0));
        this.create(body, site, context, support);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass().equals(object.getClass());
    }

    @Override
    public String getPartName(ISelection forSelection) {
        return "Selection";
    }

    public class ScrollListener
    implements Listener {
        public Control[] composites;
        public final int minSize;
        private boolean pending = false;

        public ScrollListener(int minSize) {
            this.minSize = minSize;
        }

        public void handleEvent(Event event) {
            this.handleEvent();
        }

        public void handleEvent() {
            if (this.pending) {
                return;
            }
            this.pending = true;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScrollListener.this.doHandleEvent();
                }
            });
        }

        public void doHandleEvent() {
            Point p;
            if (ConfigurationComposite.this.explorers == null || ConfigurationComposite.this.explorers.isDisposed()) {
                return;
            }
            this.pending = false;
            Point o = ConfigurationComposite.this.explorers.getSize();
            if (!o.equals((Object)(p = ConfigurationComposite.this.explorers.computeSize(-1, -1, true)))) {
                ConfigurationComposite.this.explorers.setSize(p);
            }
        }
    }
}

