/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers.e4;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ToggleFocusabilityHandler {
    private static final String HANDLED_ITEM_ID = "fi.vtt.apros.ui.diagram.handledtoolitem.enableimageeditability";
    @Inject
    private EModelService modelService;

    private void updateStateForPart(MPart part) {
        IWorkbenchPart wbPart = this.tryGetWorkbenchPart(part);
        if (wbPart != null) {
            MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)part);
            MToolItem item = (MToolItem)this.modelService.find(HANDLED_ITEM_ID, (MUIElement)win);
            ILayersEditor le = this.getLayers((IAdaptable)wbPart);
            if (item != null && le != null) {
                this.setToolItemState(item, le.getFocusImages());
            }
        }
    }

    @Inject
    @Optional
    public void receiveActivePart(@Named(value="e4ActivePart") MPart activePart) {
        this.updateStateForPart(activePart);
    }

    @CanExecute
    public boolean canExecute(@Active MPart part) {
        return this.tryGetWorkbenchPart(part) instanceof DiagramEditor;
    }

    @Execute
    public void execute(@Optional MToolItem toolItem) {
        ILayersEditor le = this.getLayers();
        if (le != null) {
            boolean newValue = !le.getFocusImages();
            le.setFocusImages(newValue);
            if (toolItem != null) {
                this.setToolItemState(toolItem, newValue);
            }
        }
    }

    private void setToolItemState(MToolItem item, boolean focusImages) {
        item.setSelected(focusImages);
        item.setTooltip(String.valueOf(focusImages ? "Deny" : "Allow") + " Focusing and Editing of Images");
    }

    protected ILayersEditor getLayers() {
        DiagramEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        return this.getLayers((IAdaptable)editor);
    }

    protected ILayersEditor getLayers(IAdaptable editor) {
        IDiagram diagram = (IDiagram)editor.getAdapter(IDiagram.class);
        if (diagram == null) {
            return null;
        }
        ILayersEditor le = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        return le;
    }

    protected DiagramEditor getEditor() {
        IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)editorPart;
            return editor;
        }
        return null;
    }

    private IWorkbenchPart tryGetWorkbenchPart(MPart part) {
        if (part == null) {
            return null;
        }
        Object obj = part.getObject();
        if (obj instanceof CompatibilityEditor) {
            CompatibilityEditor editor = (CompatibilityEditor)obj;
            return editor.getPart();
        }
        if (obj instanceof IWorkbenchPart) {
            return (IWorkbenchPart)obj;
        }
        return null;
    }
}

