/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.function.Supplier;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditorDocumentProvider;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.TitleWithParentNameRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;

public class SCLModuleEditor
extends TextEditor {
    private boolean disposed = false;
    private ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    private ResourceEditorSupport support;
    protected LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public SCLModuleEditor() {
        this.preInitialize();
    }

    public boolean isTabsToSpacesConversionEnabled() {
        return true;
    }

    protected void preInitialize() {
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew((ResourceManager)this.resourceManager);
        this.setDocumentProvider((IDocumentProvider)new SCLModuleEditorDocumentProvider(sourceViewerConfiguration));
        this.setSourceViewerConfiguration((SourceViewerConfiguration)sourceViewerConfiguration);
    }

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return this.INPUT_VALIDATOR;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.support = new ResourceEditorSupport((IEditorPart)this, this.getInputValidator());
        this.support.activateValidation();
        try {
            this.getResourceInput().init(null);
        }
        catch (DatabaseException e) {
            throw new PartInitException("Failed to initialize " + input, (Throwable)e);
        }
    }

    protected IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        StatusLineContributionItem statusLineContribution = new StatusLineContributionItem("InputPosition", true, 14);
        this.setStatusField((IStatusField)statusLineContribution, "InputPosition");
        this.getEditorSite().getActionBars().getStatusLineManager().add((IContributionItem)statusLineContribution);
        this.getEditorSite().getActionBars().updateActionBars();
        this.updatePartName();
    }

    protected void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = this::isDisposed;
            session.asyncRequest((Read)new TitleWithParentNameRequest(this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((SCLModuleEditor)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(this.getSite().getId(), this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((SCLModuleEditor)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    public void dispose() {
        this.disposed = true;
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        super.dispose();
        this.resourceManager.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

