/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableChildren;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.document.server.request.NodesRequest2;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class NodesRequest
extends VariableRead<Set<Variable>> {
    public NodesRequest(Variable var) {
        super(var);
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        ITask task = DocumentRequest.PROFILE ? ThreadLogger.task((Object)((Object)this)) : null;
        StructuralResource2.getInstance((ReadGraph)graph);
        if (this.variable == null) {
            return Collections.emptySet();
        }
        Collection children = (Collection)graph.syncRequest((Read)new VariableChildren(this.variable));
        Set nodes = (Set)graph.syncRequest((AsyncRead)new CollectNodesRequest2(children));
        if (DocumentRequest.PROFILE) {
            task.finish();
        }
        return nodes;
    }

    static class CollectNodesRequest2
    extends UnaryAsyncRead<Collection<Variable>, Set<Variable>> {
        public CollectNodesRequest2(Collection<Variable> nodes) {
            super(nodes);
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<Set<Variable>> procedure) {
            final HashSet rs = new HashSet();
            for (Variable node : (Collection)this.parameter) {
                graph.asyncRequest((Read)new NodesRequest2(node), (AsyncProcedure)new AsyncProcedure<Set<Variable>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Set<Variable> result) {
                        HashSet hashSet = rs;
                        synchronized (hashSet) {
                            rs.addAll(result);
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                    }
                });
            }
            procedure.execute(graph, rs);
        }
    }
}

