/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.IGraphLayerUtil;
import org.simantics.diagram.synchronization.graph.layer.LayersSpec;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.layers.IEditableLayer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.layers.SimpleLayers;
import org.simantics.layer0.Layer0;

public class GraphLayerManager {
    public static final boolean DEBUG_LAYERS = false;
    IModificationQueue modificationQueue;
    Resource diagram;
    Layer0 l0;
    DiagramResource dia;
    ConcurrentMap<String, GraphLayer> layers = new ConcurrentHashMap<String, GraphLayer>();
    SimpleLayers layerEditor;
    LayerListener layerListener = new LayerListener();
    boolean disposed = false;

    public GraphLayerManager(ReadGraph graph, IModificationQueue modificationQueue, Resource diagram) {
        this.modificationQueue = modificationQueue;
        this.diagram = diagram;
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        this.dia = DiagramResource.getInstance((ReadGraph)graph);
    }

    public void dispose() {
        for (ILayer layer : this.layerEditor.getLayers()) {
            if (!(layer instanceof IEditableLayer)) continue;
            ((IEditableLayer)layer).removeLayerListener((IEditableLayer.ILayerListener)this.layerListener);
        }
        this.layers.clear();
        this.disposed = true;
    }

    Resource getDiagramResource() {
        return this.diagram;
    }

    void deleteTag(WriteGraph g, Resource tag) throws DatabaseException {
        g.deny(tag);
    }

    Collection<GraphLayer> getActiveLayers(ReadGraph g) throws DatabaseException {
        ArrayList<GraphLayer> result = new ArrayList<GraphLayer>();
        for (GraphLayer gl : this.layers.values()) {
            Boolean active = (Boolean)g.getPossibleRelatedValue(gl.getLayer(), this.dia.IsActive);
            if (!Boolean.TRUE.equals(active)) continue;
            result.add(gl);
        }
        return result;
    }

    void tagElementWithActiveLayers(WriteGraph g, Resource element) throws DatabaseException {
        Collection<GraphLayer> activeLayers = this.getActiveLayers((ReadGraph)g);
        for (GraphLayer activeLayer : activeLayers) {
            DiagramGraphUtil.tag(g, element, activeLayer.getVisible(), true);
            DiagramGraphUtil.tag(g, element, activeLayer.getFocusable(), true);
        }
    }

    public ILayersEditor loadLayers(IDiagram diagram, ReadGraph g, Resource diagramResource) throws DatabaseException {
        this.layerEditor = new SimpleLayers();
        this.layerEditor.addLayerEditorListener((ILayersEditor.ILayersEditorListener)this.layerListener);
        final String[] fixed = (String[])diagram.getHint(DiagramHints.KEY_FIXED_LAYERS);
        g.syncRequest((Read)new ResourceRead<LayersSpec>(diagramResource){

            public LayersSpec perform(ReadGraph g) throws DatabaseException {
                ArrayList<GraphLayer> gls = new ArrayList<GraphLayer>();
                for (Resource layer : g.getObjects(this.resource, GraphLayerManager.this.dia.HasLayer)) {
                    IGraphLayerUtil layerUtil = (IGraphLayerUtil)g.adapt(g.getSingleObject(layer, Layer0.getInstance((ReadGraph)g).InstanceOf), IGraphLayerUtil.class);
                    GraphLayer gl = layerUtil.loadLayer(g, layer);
                    gls.add(gl);
                }
                return new LayersSpec(gls);
            }
        }, (Listener)new Listener<LayersSpec>(){

            public void execute(LayersSpec layersSpec) {
                ConcurrentHashMap<String, GraphLayer> newLayers = new ConcurrentHashMap<String, GraphLayer>();
                HashSet<ILayer> visibleLayers = new HashSet<ILayer>();
                HashSet<ILayer> allLayers = new HashSet<ILayer>();
                if (fixed != null) {
                    for (GraphLayer gl : layersSpec.getGraphLayers()) {
                        String[] stringArray = fixed;
                        int n = fixed.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name = stringArray[n2];
                            if (name.equals(gl.getName())) {
                                ILayer l = gl.getILayer();
                                newLayers.put(gl.getName(), gl);
                                allLayers.add(l);
                                visibleLayers.add(l);
                            }
                            ++n2;
                        }
                    }
                } else {
                    for (GraphLayer gl : layersSpec.getGraphLayers()) {
                        ILayer l = gl.getILayer();
                        newLayers.put(gl.getName(), gl);
                        if (l instanceof IEditableLayer) {
                            ((IEditableLayer)l).addLayerListener((IEditableLayer.ILayerListener)GraphLayerManager.this.layerListener);
                        }
                        allLayers.add(l);
                        if (!gl.isActive()) continue;
                        visibleLayers.add(l);
                    }
                }
                if (newLayers.isEmpty()) {
                    GraphLayerManager.this.layerEditor.setIgnoreVisibilitySettings(true);
                    GraphLayerManager.this.layerEditor.setIgnoreFocusSettings(true);
                }
                GraphLayerManager.this.layerEditor.update(allLayers, visibleLayers);
                GraphLayerManager.this.layers = newLayers;
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return GraphLayerManager.this.disposed;
            }
        });
        return this.layerEditor;
    }

    public void loadLayersForElement(ReadGraph graph, ILayersEditor layersEditor, IElement e, Resource element) throws DatabaseException {
        HashSet<ILayer> visible = null;
        HashSet<ILayer> focusable = null;
        for (ILayer l : layersEditor.getLayers()) {
            GraphLayer gl = (GraphLayer)this.layers.get(l.getName());
            if (gl == null) continue;
            if (graph.hasStatement(element, gl.getVisible(), element)) {
                if (visible == null) {
                    visible = new HashSet(4);
                }
                visible.add(l);
            }
            if (!graph.hasStatement(element, gl.getFocusable(), element)) continue;
            if (focusable == null) {
                focusable = new HashSet(4);
            }
            focusable.add(l);
        }
        if (visible == null) {
            visible = new HashSet<ILayer>(1);
        }
        if (focusable == null) {
            focusable = new HashSet<ILayer>(1);
        }
        e.setHint(ElementHints.KEY_VISIBLE_LAYERS, visible);
        e.setHint(ElementHints.KEY_FOCUS_LAYERS, focusable);
    }

    public void loadLayersForElement(AsyncReadGraph graph, ILayers layers2, final IElement e, Resource element, final AsyncProcedure<IElement> callback) {
        final HashSet visible = new HashSet(2);
        final HashSet focusable = new HashSet(2);
        Set allLayers = layers2.getLayers();
        if (allLayers.isEmpty()) {
            e.setHint(ElementHints.KEY_VISIBLE_LAYERS, visible);
            e.setHint(ElementHints.KEY_FOCUS_LAYERS, focusable);
            callback.execute(graph, (Object)e);
            return;
        }
        final AtomicInteger ready = new AtomicInteger(allLayers.size() * 2);
        for (final ILayer l : allLayers) {
            final GraphLayer gl = (GraphLayer)this.layers.get(l.getName());
            if (gl != null) {
                graph.forHasStatement(element, gl.getVisible(), element, (AsyncProcedure)new AsyncProcedureAdapter<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Boolean result) {
                        if (result.booleanValue()) {
                            Set set = visible;
                            synchronized (set) {
                                visible.add(l);
                            }
                        }
                        if (ready.decrementAndGet() == 0) {
                            e.setHint(ElementHints.KEY_VISIBLE_LAYERS, (Object)visible);
                            e.setHint(ElementHints.KEY_FOCUS_LAYERS, (Object)focusable);
                            callback.execute(graph, (Object)e);
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        callback.exception(graph, t);
                    }
                });
                graph.forHasStatement(element, gl.getFocusable(), element, (AsyncProcedure)new AsyncProcedureAdapter<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Boolean result) {
                        if (result.booleanValue()) {
                            Set set = focusable;
                            synchronized (set) {
                                focusable.add(l);
                            }
                        }
                        if (ready.decrementAndGet() == 0) {
                            e.setHint(ElementHints.KEY_VISIBLE_LAYERS, (Object)visible);
                            e.setHint(ElementHints.KEY_FOCUS_LAYERS, (Object)focusable);
                            callback.execute(graph, (Object)e);
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        callback.exception(graph, t);
                    }
                });
                continue;
            }
            if (ready.addAndGet(-2) != 0) continue;
            e.setHint(ElementHints.KEY_VISIBLE_LAYERS, visible);
            e.setHint(ElementHints.KEY_FOCUS_LAYERS, focusable);
            callback.execute(graph, (Object)e);
        }
    }

    public void putElementOnVisibleLayers(IDiagram diagram, WriteGraph g, Resource element) throws DatabaseException {
        ILayers diagramLayers = (ILayers)diagram.getHint(DiagramHints.KEY_LAYERS);
        if (diagramLayers != null) {
            Set visibleLayers = diagramLayers.getVisibleLayers();
            for (ILayer layer : visibleLayers) {
                GraphLayer gl = (GraphLayer)this.layers.get(layer.getName());
                if (gl == null) continue;
                gl.forEachTag((DbConsumer<Resource>)((DbConsumer)tag -> DiagramGraphUtil.tag(g, element, tag, true)));
            }
        }
    }

    public void removeFromAllLayers(WriteGraph graph, Resource element) throws ServiceException {
        graph.deny(element, this.dia.IsVisible);
        graph.deny(element, this.dia.IsFocusable);
    }

    public GraphLayer getGraphLayer(String name) {
        return (GraphLayer)this.layers.get(name);
    }

    class CreateLayer
    extends ModificationAdapter {
        final ILayer layer;
        final Resource diagram;

        public CreateLayer(ILayer layer, Resource diagram) {
            super(LOW_PRIORITY);
            assert (layer != null);
            this.layer = layer;
            this.diagram = diagram;
            if (layer instanceof IEditableLayer) {
                ((IEditableLayer)layer).addLayerListener((IEditableLayer.ILayerListener)GraphLayerManager.this.layerListener);
            }
        }

        @Override
        public void perform(WriteGraph g) throws Exception {
            String newName = this.layer.getName();
            for (Resource layer : g.getObjects(this.diagram, GraphLayerManager.this.dia.HasLayer)) {
                String name = (String)g.getRelatedValue(layer, GraphLayerManager.this.l0.HasName);
                if (!newName.equals(name)) continue;
                return;
            }
            IGraphLayerUtil util = (IGraphLayerUtil)g.adapt(DiagramResource.getInstance((ReadGraph)g).Layer, IGraphLayerUtil.class);
            GraphLayer layer = util.createLayer(g, newName, false);
            g.claim(this.diagram, GraphLayerManager.this.dia.HasLayer, layer.getLayer());
            GraphLayerManager.this.layers.put(newName, layer);
        }
    }

    class LayerActivation
    extends ModificationAdapter {
        final ILayer layer;
        final boolean activated;

        public LayerActivation(ILayer layer, boolean activated) {
            super(LOW_PRIORITY);
            assert (layer != null);
            this.layer = layer;
            this.activated = activated;
        }

        @Override
        public void perform(WriteGraph g) throws Exception {
            GraphLayer gl = (GraphLayer)GraphLayerManager.this.layers.get(this.layer.getName());
            if (gl == null) {
                throw new CancelTransactionException("Diagram has no matching layer description: " + this.layer.getName());
            }
            g.claimLiteral(gl.getLayer(), GraphLayerManager.this.dia.IsActive, (Object)this.activated);
        }
    }

    class LayerChange
    extends ModificationAdapter {
        final IEditableLayer.LayerChangeEvent event;
        final GraphLayer gl;

        public LayerChange(IEditableLayer.LayerChangeEvent event, GraphLayer gl) {
            super(LOW_PRIORITY);
            assert (event != null);
            assert (gl != null);
            this.event = event;
            this.gl = gl;
        }

        @Override
        public void perform(WriteGraph g) throws Exception {
            g.claimLiteral(this.gl.getLayer(), GraphLayerManager.this.l0.HasName, (Object)this.event.getSource().getName(), (Binding)Bindings.STRING);
        }
    }

    class LayerListener
    implements ILayersEditor.ILayersEditorListener,
    IEditableLayer.ILayerListener {
        LayerListener() {
        }

        public void layerAdded(ILayer layer) {
            GraphLayerManager.this.modificationQueue.offer(new CreateLayer(layer, GraphLayerManager.this.getDiagramResource()), null);
            GraphLayerManager.this.modificationQueue.flush();
        }

        public void layerRemoved(ILayer layer) {
            GraphLayerManager.this.modificationQueue.offer(new RemoveLayer(layer, GraphLayerManager.this.getDiagramResource()), null);
            GraphLayerManager.this.modificationQueue.flush();
        }

        public void layerActivated(ILayer layer) {
            this.postActivation(layer, true);
        }

        public void layerDeactivated(ILayer layer) {
            this.postActivation(layer, false);
        }

        public void ignoreFocusChanged(boolean value) {
        }

        public void ignoreVisibilityChanged(boolean value) {
        }

        void postActivation(ILayer layer, boolean activated) {
            GraphLayerManager.this.modificationQueue.offer(new LayerActivation(layer, activated), null);
            GraphLayerManager.this.modificationQueue.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layerChanged(IEditableLayer.LayerChangeEvent event) {
            LayerChange change = null;
            if ("name".equals(event.getProperty())) {
                String oldName = (String)event.getOldValue();
                String newName = (String)event.getNewValue();
                ConcurrentMap<String, GraphLayer> concurrentMap = GraphLayerManager.this.layers;
                synchronized (concurrentMap) {
                    GraphLayer gl = (GraphLayer)GraphLayerManager.this.layers.remove(oldName);
                    if (gl == null) {
                        return;
                    }
                    GraphLayerManager.this.layers.put(newName, gl.withName(newName));
                    change = new LayerChange(event, gl);
                }
            }
            if (change != null) {
                GraphLayerManager.this.modificationQueue.offer(change, null);
                GraphLayerManager.this.modificationQueue.flush();
            }
        }
    }

    class RemoveLayer
    extends ModificationAdapter {
        final ILayer layer;
        final Resource diagram;

        public RemoveLayer(ILayer layer, Resource diagram) {
            super(LOW_PRIORITY);
            assert (layer != null);
            this.layer = layer;
            this.diagram = diagram;
            if (layer instanceof IEditableLayer) {
                ((IEditableLayer)layer).removeLayerListener((IEditableLayer.ILayerListener)GraphLayerManager.this.layerListener);
            }
        }

        @Override
        public void perform(WriteGraph g) throws Exception {
            String removedName = this.layer.getName();
            for (Resource l : g.getObjects(this.diagram, GraphLayerManager.this.dia.HasLayer)) {
                String name = (String)g.getRelatedValue(l, GraphLayerManager.this.l0.HasName);
                if (!removedName.equals(name)) continue;
                g.denyStatement(this.diagram, GraphLayerManager.this.dia.HasLayer, l);
                this.deleteLayer(g, l);
                GraphLayerManager.this.layers.remove(name);
                return;
            }
        }

        void deleteLayer(WriteGraph g, Resource layer) throws DatabaseException {
            RemoverUtil.remove((WriteGraph)g, (Resource)layer);
        }
    }
}

