/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.Resource;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple3;

public class StyleBaseData {
    private static StyleBaseData INSTANCE;
    protected final Map<Tuple, Object> values = new ConcurrentHashMap<Tuple, Object>();
    private Map<Tuple3, ObserverGroupListener> listeners = new HashMap<Tuple3, ObserverGroupListener>();
    private final Map<Style, List<Resource>> removals = new HashMap<Style, List<Resource>>();

    private StyleBaseData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StyleBaseData getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<StyleBaseData> clazz = StyleBaseData.class;
        synchronized (StyleBaseData.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new StyleBaseData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void removeValue(Tuple t) {
        this.values.remove(t);
    }

    public void putValue(Tuple t, Object o) {
        this.values.put(t, o);
    }

    public <T> T getValue(Tuple t) {
        return (T)this.values.get(t);
    }

    public synchronized void removeItem(Style s, Resource r) {
        List<Resource> l = this.removals.get(s);
        if (l == null) {
            l = new ArrayList<Resource>();
            this.removals.put(s, l);
        }
        l.add(r);
    }

    public void putListener(Tuple3 key, ObserverGroupListener listener) {
        this.listeners.put(key, listener);
    }

    public void removeListener(Tuple3 key) {
        this.listeners.remove(key);
    }

    public ObserverGroupListener getListener(Tuple3 key) {
        return this.listeners.get(key);
    }

    public synchronized void applyRemovals(EvaluationContext evaluationContext, StyleBase<?> s) {
        List<Resource> rs = this.removals.remove(s);
        if (rs == null) {
            return;
        }
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        for (Resource item : rs) {
            s.cleanupStyleForItem(evaluationContext, map, item);
        }
    }
}

