/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.ProfileActivityBean;
import org.simantics.diagram.profile.Profiles;
import org.simantics.diagram.profile.TopLevelProfiles;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.simulation.ontology.SimulationResource;

class ProfileActivityBeanRequest
extends ResourceRead<ProfileActivityBean> {
    public ProfileActivityBeanRequest(Resource root) {
        super(root);
    }

    public ProfileActivityBean perform(ReadGraph graph) throws DatabaseException {
        ProfileActivityBean bean = new ProfileActivityBean();
        String rootUri = graph.getPossibleURI(this.resource);
        if (rootUri == null) {
            return bean;
        }
        for (NamedResource r : (List)graph.syncRequest((Read)new TopLevelProfiles(this.resource))) {
            ProfileActivityBean.Profile prof = ProfileActivityBeanRequest.readProfile(graph, rootUri, r.getResource());
            if (prof == null) continue;
            bean.topLevelProfiles.put(prof.relativeUri, prof);
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource activeProfile = graph.getPossibleObject(this.resource, DIA.HasActiveProfile);
        if (activeProfile != null) {
            bean.activeProfile = Profiles.possiblyRelativeUri(graph, rootUri, activeProfile);
        }
        return bean;
    }

    private static ProfileActivityBean.Profile readProfile(ReadGraph graph, String rootUri, Resource profile) throws DatabaseException {
        ProfileActivityBean.Profile prof = new ProfileActivityBean.Profile();
        prof.relativeUri = Profiles.possiblyRelativeUri(graph, rootUri, profile);
        if (prof.relativeUri == null) {
            return null;
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        for (Resource active : graph.getObjects(profile, SIMU.IsActive)) {
            String euri = Profiles.possiblyRelativeUri(graph, rootUri, active);
            if (euri == null) continue;
            prof.activeEntries.add(euri);
        }
        return prof;
    }
}

