/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.text.Format;
import org.simantics.g2d.utils.GridSpacing;
import org.simantics.scenegraph.utils.GridUtils;

public class GridUtil {
    public static final BasicStroke GRID_LINE_STROKE;
    public static final BasicStroke RULER_LINE_STROKE;
    public static final Font RULER_FONT;
    public static final Font RULER_FONT_BOLD;
    public static final FontRenderContext frc;

    static {
        frc = new FontRenderContext(null, true, true);
        RULER_LINE_STROKE = new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f);
        GRID_LINE_STROKE = new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f);
        RULER_FONT = new Font("Tahoma", 0, 12);
        RULER_FONT_BOLD = new Font("Tahoma", 1, 12);
    }

    public static void paintGridLines(GridSpacing xgrid, GridSpacing ygrid, Graphics2D g, double xMin, double yMax, double controlWidth, double controlHeightForVerticalLines, double controlHeightForHorizLines) {
        g.setStroke(GRID_LINE_STROKE);
        Line2D.Double line = new Line2D.Double();
        if (xgrid != null) {
            double controlX = GridUtils.distanceToNextGridCoordScaled((double)xMin, (double)xgrid.segment, (double)xgrid.pixelsPerUnit);
            while (controlX <= controlWidth + 0.1) {
                ((Line2D)line).setLine(controlX, 0.0, controlX, (int)(controlHeightForVerticalLines - 1.0));
                g.draw(line);
                controlX += xgrid.pixelsPerSegment;
            }
        }
        if (ygrid != null) {
            double canvasDiff = GridUtils.distanceToNextGridCoord((double)yMax, (double)ygrid.segment);
            double controlY = controlHeightForHorizLines - canvasDiff * ygrid.pixelsPerUnit;
            while (controlY >= -0.1) {
                ((Line2D)line).setLine(0.0, controlY, (int)(controlWidth - 1.0), controlY);
                g.draw(line);
                controlY -= ygrid.pixelsPerSegment;
            }
        }
    }

    public static void paintHorizontalRuler(GridSpacing grid, Graphics2D g, double xMin, double controlWidth, Format labelFormat) {
        g.setStroke(RULER_LINE_STROKE);
        double canvasDiff = GridUtils.distanceToNextGridCoord((double)xMin, (double)grid.segment);
        double canvasX = xMin + canvasDiff;
        double controlX = canvasDiff * grid.pixelsPerUnit;
        Line2D.Double line = new Line2D.Double();
        ((Line2D)line).setLine(0.0, 3.0, controlWidth, 3.0);
        g.draw(line);
        while (controlX <= controlWidth + 0.1) {
            ((Line2D)line).setLine(controlX, 3.0, controlX, 8.0);
            g.draw(line);
            controlX += grid.pixelsPerSegment;
        }
        Font font = RULER_FONT;
        g.setFont(RULER_FONT);
        FontMetrics fm = g.getFontMetrics(font);
        canvasDiff = GridUtils.distanceToNextGridCoord((double)xMin, (double)grid.segment);
        double canvasStart = canvasX = xMin + canvasDiff;
        controlX = canvasDiff * grid.pixelsPerUnit;
        int i = 0;
        while (controlX <= controlWidth + 0.1) {
            String value = labelFormat.format(canvasX);
            double labelCenter = fm.getStringBounds(value, g).getCenterX();
            g.drawString(value, (float)(controlX - labelCenter), 20.0f);
            controlX += grid.pixelsPerSegment;
            canvasX = canvasStart + grid.segment * (double)(++i);
        }
    }

    public static void paintVerticalRuler(GridSpacing grid, Graphics2D g, double yMin, double controlHeight, Format labelFormat) {
        double canvasY;
        g.setStroke(RULER_LINE_STROKE);
        double canvasDiff = GridUtils.distanceToNextGridCoord((double)(yMin + grid.segment), (double)grid.segment);
        double controlY = controlHeight - canvasDiff * grid.pixelsPerUnit;
        Line2D.Double line = new Line2D.Double();
        ((Line2D)line).setLine(3.0, 0.0, 3.0, controlHeight);
        g.draw(line);
        while (controlY >= -0.1) {
            ((Line2D)line).setLine(3.0, controlY, 8.0, controlY);
            g.draw(line);
            controlY -= grid.pixelsPerSegment;
        }
        g.setFont(RULER_FONT);
        FontMetrics fm = g.getFontMetrics(RULER_FONT);
        canvasDiff = GridUtils.distanceToNextGridCoord((double)yMin, (double)grid.segment);
        double canvasStart = canvasY = yMin + canvasDiff;
        controlY = controlHeight - canvasDiff * grid.pixelsPerUnit;
        int i = 0;
        while (controlY >= -0.1) {
            String value = labelFormat.format(canvasY);
            LineMetrics lm = fm.getLineMetrics(value, g);
            g.drawString(value, 13.0f, (float)(controlY + (double)(lm.getAscent() / 2.0f)) - 1.0f);
            controlY -= grid.pixelsPerSegment;
            canvasY = canvasStart + grid.segment * (double)(++i);
        }
    }

    public static void paintVerticalSlaveRuler(GridSpacing masterGrid, GridSpacing slaveGrid, Graphics2D g, double yMinMaster, double yMinSlave, double controlHeight, Format labelFormat) {
        double masterY;
        double startY;
        g.setStroke(RULER_LINE_STROKE);
        double canvasDiff = GridUtils.distanceToNextGridCoord((double)(yMinMaster + masterGrid.segment), (double)masterGrid.segment);
        double controlDiff = canvasDiff * masterGrid.pixelsPerUnit;
        double controlY = startY = controlHeight - controlDiff;
        Line2D.Double line = new Line2D.Double();
        ((Line2D)line).setLine(3.0, 0.0, 3.0, controlHeight);
        g.draw(line);
        while (controlY >= -0.1) {
            ((Line2D)line).setLine(3.0, controlY, 8.0, controlY);
            g.draw(line);
            controlY -= masterGrid.pixelsPerSegment;
        }
        g.setFont(RULER_FONT);
        FontMetrics fm = g.getFontMetrics(RULER_FONT);
        canvasDiff = GridUtils.distanceToNextGridCoord((double)yMinMaster, (double)masterGrid.segment);
        double canvasStart = masterY = yMinMaster + canvasDiff;
        controlY = controlHeight - canvasDiff * masterGrid.pixelsPerUnit;
        int i = 0;
        while (controlY >= -0.1) {
            double slaveY = (masterY - yMinMaster) * masterGrid.pixelsPerUnit * slaveGrid.unitsPerPixel + yMinSlave;
            if (Math.abs(slaveY) < 1.0E-5) {
                slaveY = 0.0;
            }
            String value = labelFormat.format(slaveY);
            LineMetrics lm = fm.getLineMetrics(value, g);
            g.drawString(value, 13.0f, (float)(controlY + (double)(lm.getAscent() / 2.0f)) - 1.0f);
            controlY -= masterGrid.pixelsPerSegment;
            masterY = canvasStart + masterGrid.segment * (double)(++i);
        }
    }

    public static int getTickCount(GridSpacing grid, double yMin, double controlHeight) {
        double canvasDiff = GridUtils.distanceToNextGridCoord((double)(yMin + grid.segment), (double)grid.segment);
        double startY = controlHeight - canvasDiff * grid.pixelsPerUnit;
        double x = startY / grid.pixelsPerSegment;
        return (int)Math.ceil(x);
    }

    public static double calcLabelWidth(double xMin, double xMax, Format format, GridSpacing grid) {
        double canvasStart;
        double width = 0.0;
        double canvasDiff = GridUtils.distanceToNextGridCoord((double)xMin, (double)grid.segment);
        int c = 0;
        double x = canvasStart = xMin + canvasDiff;
        while (x < xMax) {
            String label = format.format(x);
            if (label == null || label.equals("")) continue;
            GlyphVector glyphVector = RULER_FONT.createGlyphVector(frc, label);
            double labelWidth = glyphVector.getVisualBounds().getWidth();
            width = Math.max(width, labelWidth);
            if (c++ > 100) break;
            x = canvasStart + grid.segment * (double)c;
        }
        return width * 1.05;
    }
}

