/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.layers;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.layers.SimpleLayer;
import org.simantics.utils.strings.AlphanumComparator;

public class SimpleLayers
implements ILayersEditor {
    private static final Comparator<ILayer> LAYER_COMPARATOR = new Comparator<ILayer>(){

        @Override
        public int compare(ILayer o1, ILayer o2) {
            return AlphanumComparator.COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());
        }
    };
    private Set<ILayer> all = new TreeSet<ILayer>(LAYER_COMPARATOR);
    private volatile Set<ILayer> allSnapshot;
    private Set<ILayer> visible = new TreeSet<ILayer>(LAYER_COMPARATOR);
    private volatile Set<ILayer> visibleSnapshot;
    private CopyOnWriteArrayList<ILayersEditor.ILayersEditorListener> layerEditorListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ILayers.ILayersListener> layersListeners = new CopyOnWriteArrayList();
    private boolean ignoreFocusSettings = false;
    private boolean ignoreVisibilitySettings = false;
    private boolean focusImages = false;

    public SimpleLayers() {
    }

    public SimpleLayers(String ... content) {
        String[] stringArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            SimpleLayer layer = new SimpleLayer(s);
            this.all.add(layer);
            this.visible.add(layer);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Set<ILayer> allLayers, Set<ILayer> visibleLayers) {
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            this.all.clear();
            this.all.addAll(allLayers);
            this.visible.clear();
            this.visible.addAll(visibleLayers);
            this.allSnapshot = null;
            this.visibleSnapshot = null;
        }
        for (ILayers.ILayersListener listener : this.layersListeners) {
            listener.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ILayer> getLayers() {
        if (this.allSnapshot == null) {
            SimpleLayers simpleLayers = this;
            synchronized (simpleLayers) {
                if (this.allSnapshot == null) {
                    TreeSet<ILayer> ss = new TreeSet<ILayer>(LAYER_COMPARATOR);
                    ss.addAll(this.all);
                    this.allSnapshot = Collections.unmodifiableSet(ss);
                }
            }
        }
        return this.allSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ILayer> getVisibleLayers() {
        if (this.visibleSnapshot == null) {
            SimpleLayers simpleLayers = this;
            synchronized (simpleLayers) {
                if (this.visibleSnapshot == null) {
                    TreeSet<ILayer> ss = new TreeSet<ILayer>(LAYER_COMPARATOR);
                    ss.addAll(this.visible);
                    this.visibleSnapshot = Collections.unmodifiableSet(ss);
                }
            }
        }
        return this.visibleSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(ILayer layer) {
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            return this.visible.contains(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate(ILayer layer) {
        boolean deactivated = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            deactivated = this.visible.remove(layer);
        }
        if (deactivated) {
            SimpleLayers simpleLayers2 = this;
            synchronized (simpleLayers2) {
                this.visibleSnapshot = null;
            }
            for (ILayers.ILayersListener iLayersListener : this.layersListeners) {
                iLayersListener.changed();
            }
            for (ILayersEditor.ILayersEditorListener iLayersEditorListener : this.layerEditorListeners) {
                iLayersEditorListener.layerDeactivated(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(ILayer layer) {
        boolean activated = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            activated = this.visible.add(layer);
        }
        if (activated) {
            SimpleLayers simpleLayers2 = this;
            synchronized (simpleLayers2) {
                this.visibleSnapshot = null;
            }
            for (ILayers.ILayersListener iLayersListener : this.layersListeners) {
                iLayersListener.changed();
            }
            for (ILayersEditor.ILayersEditorListener iLayersEditorListener : this.layerEditorListeners) {
                iLayersEditorListener.layerActivated(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayer(ILayer layer) {
        boolean added = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            added = this.all.add(layer);
        }
        if (added) {
            SimpleLayers simpleLayers2 = this;
            synchronized (simpleLayers2) {
                this.allSnapshot = null;
            }
            for (ILayers.ILayersListener iLayersListener : this.layersListeners) {
                iLayersListener.changed();
            }
            for (ILayersEditor.ILayersEditorListener iLayersEditorListener : this.layerEditorListeners) {
                iLayersEditorListener.layerAdded(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayer(ILayer layer) {
        boolean removed = false;
        SimpleLayers simpleLayers = this;
        synchronized (simpleLayers) {
            removed = this.all.remove(layer);
            this.visible.remove(layer);
        }
        if (removed) {
            SimpleLayers simpleLayers2 = this;
            synchronized (simpleLayers2) {
                this.allSnapshot = null;
                this.visibleSnapshot = null;
            }
            for (ILayers.ILayersListener iLayersListener : this.layersListeners) {
                iLayersListener.changed();
            }
            for (ILayersEditor.ILayersEditorListener iLayersEditorListener : this.layerEditorListeners) {
                iLayersEditorListener.layerRemoved(layer);
            }
        }
    }

    @Override
    public void addLayerEditorListener(ILayersEditor.ILayersEditorListener listener) {
        this.layerEditorListeners.add(listener);
    }

    @Override
    public void removeLayerEditorListener(ILayersEditor.ILayersEditorListener listener) {
        this.layerEditorListeners.remove(listener);
    }

    @Override
    public void addLayersListener(ILayers.ILayersListener listener) {
        this.layersListeners.add(listener);
    }

    @Override
    public void removeLayersListener(ILayers.ILayersListener listener) {
        this.layersListeners.remove(listener);
    }

    @Override
    public boolean getIgnoreFocusSettings() {
        return this.ignoreFocusSettings;
    }

    @Override
    public void setIgnoreFocusSettings(boolean value) {
        boolean changed = this.ignoreFocusSettings ^ value;
        this.ignoreFocusSettings = value;
        if (changed) {
            for (ILayers.ILayersListener iLayersListener : this.layersListeners) {
                iLayersListener.changed();
            }
            for (ILayersEditor.ILayersEditorListener iLayersEditorListener : this.layerEditorListeners) {
                iLayersEditorListener.ignoreFocusChanged(value);
            }
        }
    }

    @Override
    public boolean getIgnoreVisibilitySettings() {
        return this.ignoreVisibilitySettings;
    }

    @Override
    public void setIgnoreVisibilitySettings(boolean value) {
        boolean changed = this.ignoreVisibilitySettings ^ value;
        this.ignoreVisibilitySettings = value;
        if (changed) {
            for (ILayers.ILayersListener iLayersListener : this.layersListeners) {
                iLayersListener.changed();
            }
            for (ILayersEditor.ILayersEditorListener iLayersEditorListener : this.layerEditorListeners) {
                iLayersEditorListener.ignoreVisibilityChanged(value);
            }
        }
    }

    @Override
    public boolean getFocusImages() {
        return this.focusImages;
    }

    @Override
    public void setFocusImages(boolean value) {
        this.focusImages = value;
    }
}

