/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import gnu.trove.map.hash.THashMap;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.utils.geom.DirectionSet;

public class Terminals
implements TerminalLayout,
TerminalTopology {
    private static final long serialVersionUID = -6532093690907028016L;
    protected final Map<Topology.Terminal, ObjectTerminal> terminalMap = new THashMap();
    protected final ArrayList<Topology.Terminal> terminals = new ArrayList();

    public Terminals(Collection<ObjectTerminal> ts) {
        for (ObjectTerminal ti : ts) {
            this.terminals.add(ti);
            this.terminalMap.put(ti, ti);
        }
    }

    @Override
    public AffineTransform getTerminalPosition(IElement node, Topology.Terminal t) {
        ObjectTerminal ti = this.terminalMap.get(t);
        if (ti == null) {
            return null;
        }
        return ti.getTransform();
    }

    @Override
    public void getTerminals(IElement e, Collection<Topology.Terminal> result) {
        result.addAll(this.terminals);
    }

    @Override
    public boolean getTerminalDirection(IElement node, Topology.Terminal t, DirectionSet directions) {
        ObjectTerminal ti = this.terminalMap.get(t);
        if (ti == null) {
            return false;
        }
        directions.addAll(ti.getDirections());
        return true;
    }

    @Override
    public Shape getTerminalShape(IElement node, Topology.Terminal t) {
        ObjectTerminal ti = this.terminalMap.get(t);
        if (ti == null) {
            return null;
        }
        return ti.getShape();
    }

    public int hashCode() {
        return this.terminalMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Terminals other = (Terminals)obj;
        return this.terminalMap.equals(other.terminalMap);
    }
}

